<?php
class commonModel {
	var $tag_items = array();
	var $tag_prefix="flexform";
	
	function commonModel(){	
	}
    private function unserialize_vars($text,$rev=false) {
		if (preg_match("/^\w+: /", $text)) return unserialize_text($text);
		$array = array();
		$text = ltrim($text);
		$pat = array('/""/', '/^"(.*)"$/');
		$rep = array('"', '$1');
		$delm = preg_match('/[\n\r]/', $text)?'\n\r':',\n\r'; // allow comma format
		while ($text && preg_match("/^(\"[^\"]*\"|[^\"$delm]*)*[$delm]?/", $text, $d)) {
		    $ln = preg_replace("/[\\s$delm]\$/", '', $d[0]);
		    $text = ltrim(substr($text, strlen($d[0])));
		    if (preg_match('/^\s*([^=]+)\s*=\s*(.*)$/', $ln, $d)) {
			if (preg_match('/^#/', $d[1])) continue;
			if ($rev) {
			    $k = $d[2];
			    $v = $d[1];
			} else {
			    $k = $d[1];
			    $v = $d[2];
			}
			$array[$k] = preg_replace($pat, $rep, $v);
		    }
		}
		return $array;
    }
	
	private function cc_csv_parse($ln) {
	    $result = array();
	    $rec = array();
	    while ($ln && preg_match('/^("[^"]*(?:""[^"]*)*"|[^,\t\r\n]*)[,\t]?/', $ln, $d)) {
			$rec[] = preg_replace('/""/', '"', preg_replace('/"([^"]*)"$/s', '$1', $d[1]));
			$ln = substr($ln, strlen($d[0]));
			if (preg_match("/^[\r\n]/", $ln)) {
			    $result[] = $rec;
			    $rec = array();
			    $ln = preg_replace("/^[\r\n]\n?/", '', $ln);
			}
	    }
	    if (count($rec)) $result[] = $rec;
	    return $result;
	}
	private function eval_user_value($str) {
		global $xoopsUser;
	    static $defuser;
	    if (empty($defuser)) {
			global $xoopsUser;
			$defuser = array();
			$user = is_object($xoopsUser)?$xoopsUser:new XoopsUser;
			$keys = array_keys($user->getVars());
			if (is_object($xoopsUser)) {
			    foreach ($keys as $k) {
					$defuser['{X_'.strtoupper($k).'}'] = $xoopsUser->getVar($k, 'e');
			    }
			} else {
			    foreach ($keys as $k) {
					$defuser['{X_'.strtoupper($k).'}'] = '';
			    }
			}
	    }
	    return str_replace(array_keys($defuser), $defuser, $str);
	}	
	// attribute config option expanding
	private function get_attr_value($pri, $name=null, $value=null) {
	    static $defs;		// default option value
	
	    if ($name && is_array($pri) && isset($pri[$name])) return $pri[$name];
	    if (!isset($defs)) {
			$defs = array('numeric'=>'[-+]?[0-9]+', 'tel'=>'\+?[0-9][0-9-,]*[0-9]');
			$attrs = 'size,rows,maxlength,cols,prop,notify_with_email';
			foreach (explode(',', $attrs) as $key) {
			    $defs[$key] = 0;
			}
			// override module config values
        	$config_handler =& xoops_gethandler('config');
        	$moduleConfig =& $config_handler->getConfigsByDirname('cartb2b');
			$def_attr = $moduleConfig['def_attrs'];
			foreach ($this->unserialize_vars($def_attr) as $k => $v) {
			    $defs[$k] = $v;
			}
	    }
	    if ($name == null && !is_null($pri)) {
			// override values
			if (!is_array($pri)) $pri = $this->unserialize_vars($pri);
			foreach ($pri as $k => $v) {
			    $defs[$k] = $v;
			}
    	}
    	if (isset($defs[$name])) return $defs[$name];
    	return $value;
	}	

	
	function cc_attach_image($id, $file, $urlonly=false, $add='') {
    	if (empty($file)) return "";
    	$rurl = "file.php?".($id?"id=$id&":"")."file=".urlencode($file).($add?"&$add":"");
    	if ($urlonly) return XOOPS_URL."/modules/".basename(dirname(__FILE__))."/$rurl";
    	$path = XOOPS_UPLOAD_PATH.cc_attach_path($id, $file);
    	$xy = getimagesize($path);
    	if ($xy) {
			if ($xy[0]>$xy[1] && $xy[0]>300) $extra = " width='300'";
			elseif ($xy[1]>300) $extra = " height='300'";
			else $extra = "";
			$extra .= " alt='".htmlspecialchars($file, ENT_QUOTES)."'";
			return "<img src='$rurl' class='myphoto' $extra />";
    	} else {
			$size = return_unit_bytes(filesize($path));
			return "<a href='$rurl' class='myattach'>$file ($size)</a>";
    	}
	}
	private function cc_make_widget($item, $vars=null) {
    	global $myts;
    	$fname = $item['field'];
    	$value = null;
    	$type = $item['type'];
    	$options = &$item['options'];
    	if (isset($_POST[$fname])) {
			$value = &$_POST[$fname];
			if (!is_array($value)) $value = $myts->stripSlashesGPC($value);
    	} else {
			if (isset($item['default'])) $value = $item['default'];
    	}
    	/*
    	if (isset($options)) {
			if (isset($options[LABEL_ETC])) {
			    $ereg = '/^'.preg_quote(strip_tags($options[LABEL_ETC]), '/').'\s+/';
			    if ($type == 'checkbox') {
					if (is_array($value)) {
			    		foreach ($value as $key => $val) {
							if (preg_match($ereg, $val)) {
							    $item['etc_value'] = preg_replace($ereg, '', $val);
							    $value[$key] = LABEL_ETC;
							}
			    		}
					}
		 		} else {
					if (preg_match($ereg, $value)) {
			    		$item['etc_value'] = preg_replace($ereg, '', $value);
			    		$value = LABEL_ETC;
					}
		    	}
			}
	    }*/
	    $item['value'] = $value;
	    $tpl=new XoopsTpl;
	   	$tpl->assign('item', $item);
	   	if (isset($vars)) $tpl->assign($vars);
    	return $tpl->fetch('db:cartb2b_form_widgets.html');
	}		
	function assign_form_widgets($conf=false) {
    	$mconf = !$conf;
    	$updates = array();
    	foreach ($this->tag_items as $item) {
			if (empty($item['field'])) { // comment only
			    $updates[] = $item;
			    continue;
			}
			if ($item['type']=='hidden' && !$conf) continue;
			$val = $item['value'];
			$fname = $item['field'];
			$opts = $item['options'];
			if ($conf) {
			    if (is_array($val)) {
					$fmt = "<input type='hidden' name='{$fname}[]' value='%s' />";
					$input = "";
					foreach ($val as $k=>$v) {
					    $val[$k] = $v = isset($opts[$v])?strip_tags($opts[$v]):$v;
					    $v = htmlspecialchars($v, ENT_QUOTES);
					    $input .= sprintf($fmt, $v);
					}
					$input .= htmlspecialchars(join(', ', $val), ENT_QUOTES);
			    } else {
					$v = htmlspecialchars($val, ENT_QUOTES);
					switch ($item['type']) {
					case 'hidden':
					    $input = $v;
					    break;
					case 'radio':
					case 'select':
					    $input = (isset($opts[$val])?strip_tags($opts[$val]):$v)."<input type='hidden' name='$fname' value='$v' />";
					    break;
					case 'file':
					    $input = cc_attach_image(0, $val, false)."<input type='hidden' name='$fname' value='$v' />";
					    break;
					default:
					    $input = nl2br($v)."<input type='hidden' name='$fname' value='$v' />";
					    break;
					}
			    }
			} else {
			    $input = $this->cc_make_widget($item);
			    if ($mconf && isset($item['type']) && $item['type']=='mail' &&
					isset($item['attr']['check'])&& $item['attr']['check']=='require') {
					$cfname = $fname.'_conf';
					$citem = array(
					    'name'=>sprintf(_MD_CONF_LABEL, $item['name']),
					    'label'=>sprintf(_MD_CONF_LABEL, $item['label']),
					    'field'=>$cfname, 'type'=>$item['type'],
					    'comment'=>_MD_CONF_DESC, 'attr'=>$item['attr']
					);
					$item['input'] = $input;
					$updates[] = $item;
					$input = $this->cc_make_widget($citem);
					$item = $citem;
					$mconf = false;
			    }
			}
			$item['input'] = $input;
			$updates[] = $item;
    	}
    	$items = $updates;
    	return $updates;
	}
	function tag2tagItems($defs, $labels='') {		
		$labs = $this->unserialize_vars($labels);
		$num = 0;
	    $result = array();
	    $types = array('text', 'checkbox', 'radio', 'textarea', 'select', 'hidden','const', 'mail', 'file', 'date');
	    foreach ($this->cc_csv_parse($defs) as $opts) {
	    	if (empty($opts)) continue;
			if (preg_match('/^#/', $opts[0])) {
			    $result[] = array('comment'=>substr(join(',', $opts), 1));
			    continue;
			}
			$name = array_shift($opts);
			if (preg_match('/=(.*)$/', $name, $d)) { // use alternative label
			    $label = $d[1];
			    $name = preg_replace('/=(.*)$/', '', $name);
			} else {
			    $label = isset($labs[$name])?$labs[$name]:$name;
			}
			$type='text';
			$comment='';
			$attr = array();
			if (count($opts) && in_array($opts[0], $types)) {
			    $type = array_shift($opts);
			}
			if (preg_match('/\*$/', $name)) { // syntax convention
			    $attr['check'] = 'require';
			    $name = preg_replace('/\s*\*$/', '', $name);
			    if (defined('_MD_REQUIRE_MARK')) $label = preg_replace('/\s*\*$/', _MD_REQUIRE_MARK, $label);
			}
			
			while (isset($opts[0]) && (preg_match('/^(size|rows|maxlength|cols|prop)=(\d+)$/', $opts[0], $d) || preg_match('/^(check)=(.+)$/', $opts[0], $d))) {
			    array_shift($opts);
			    $attr[$d[1]] = $d[2];
			}
			$options = array();
			$defs = array();
			if (count($opts)) {
			    while(count($opts) && !preg_match('/^\s*#/', $opts[0])) {
					$v = array_shift($opts);
					$sv = preg_split('/=/', $v, 2);
					if (count($sv)>1) {
					    $k = strip_tags($sv[0]);
					    $sk = preg_replace('/\+$/', '', $k);  // real value
					    if ($k != $sk) $defs[] = $sk;	  // defaults
					    $options[$sk] = $sv[1];
					} else {
					    $k = strip_tags($v);
					    $sk = preg_replace('/\+$/', '', $k);  // real value
					    if ($k != $sk) $defs[] = $sk;	  // defaults
					    $options[$sk] = preg_replace('/\+$/', '', $v);
					}
			    }
			    if (count($opts)) {
					$opts[0] = preg_replace('/^\s*#/','', $opts[0]);
					$comment = join(',',$opts);
			    }
			}
			
			if ($type == 'radio') {
			    $defs = $defs?$defs[0]:'';
			} elseif ($type != 'checkbox') {
			    $defs = $this->eval_user_value(join(',', $options));
			}
			if ($type=='date') {
			    if (empty($defs)) $defs = formatTimestamp(time(), 'Y-m-d');
			} elseif ($type=='textarea') {
			    $attr['rows'] = $this->get_attr_value($attr, 'rows');
			    $attr['cols'] = $this->get_attr_value($attr, 'cols');
			} else {
				$attr['size'] = $this->get_attr_value($attr, 'size');
			}			
			$fname = $this->tag_prefix . ++$num;
			$result[$name] = array(
			    'name'=>$name, 'label'=>$label, 'field'=>$fname,
			    'options'=>$options, 'type'=>$type, 'comment'=>$comment,
			    'attr'=>$attr, 'default'=>$defs);
	    }
	    $this->tag_items = $result;
	    return $result;
	}
	function post2tagItems() {
    	$myts =& MyTextSanitizer::getInstance();
    	
    	$errors = array();
    	foreach ($this->tag_items as $key=>$item) {
    		if (empty($item['field'])) continue;
			$postName = $item['field'];
			$type = $item['type'];
			$lab = $item['label'];
			$attr = $item['attr'];
			$check = !empty($attr['check']) ? $attr['check'] : "";
			$val = '';
			if (isset($_POST[$postName])) {
			    $val = $_POST[$postName];
			    if (is_array($val)) {
					//echo "value is array<br />";var_dump($val); echo "<br />";
			    	foreach ($val as $n=>$v) {
					    $val[$n] = $myts->stripSlashesGPC($v);
					}
			    } else {
					//echo "value=[" . $val ."]<br />";
			    	$val = $myts->stripSlashesGPC($val);
			    }
			}
			
			switch ($check) {
			case '':
			    break;
			case 'require':
			    if ($val==='') $errors[] = $lab.": "._MD_REQUIRE_ERR;
			    break;
			case 'mail':
			    if (!checkEmail($val)) $errors[] = $lab.": "._MD_ADDRESS_ERR;
			    break;
			case 'num':
			    $check='numeric';
			default:
			    $v = $this->get_attr_value(null, $check);
			    if (!empty($v)) $check = $v;
			    if (!preg_match('/^'.$check.'$/', $val)) $errors[] = $lab.": ".($val?_MD_REGEXP_ERR:_MD_REQUIRE_ERR);
			    break;
			}
			switch ($type) {
			case 'checkbox':
			    if (empty($val)) $val = array();
	    		$idx = array_search(LABEL_ETC, $val);	 // etc
			    if (is_int($idx)) {
					$val[$idx] = strip_tags($item['options'][LABEL_ETC])." ".$myts->stripSlashesGPC($_POST[$postName."_etc"]);
			    }
		    	break;
			case 'radio':
			    if ($val == LABEL_ETC) {			// etc
					$val = strip_tags($item['options'][LABEL_ETC])." ".$myts->stripSlashesGPC($_POST[$postName."_etc"]);
			    }
			    break;
			case 'hidden':
			case 'const':
			    $val = $this->eval_user_value(join(',', $item['options']));
			    break;
			case 'file':
			    $val = '';		// filename
			    $upfile = isset($_FILES[$postName])?$_FILES[$postName]:array('name'=>'');
			    if (isset($_POST[$postName."_prev"])) {
					$val = $myts->stripSlashesGPC($_POST[$postName."_prev"]);
					if (!empty($upfile['postName'])) {
					    unlink(XOOPS_UPLOAD_PATH.$this->cc_attach_path(0, $val));
		    			$val = '';
					}
	    		}
	    		if (empty($val)) {
					$val = $upfile['postName'];
					if ($val){
						$this->move_attach_file($upfile['tmp_name'], $val);
					} elseif (isset($_POST[$postName])) {	// confirm
		    			$val = $myts->stripSlashesGPC($_POST[$postName]);
					}
			    }
	    		break;
			case 'mail':
			    $postName .= '_conf';
			    if (!checkEmail($val)) {
					$errors[] = $lab.": "._MD_ADDRESS_ERR;
			    }
			    if (isset($_POST[$name])) {
					if ($val != $myts->stripSlashesGPC($_POST[$postName])) {
					    $errors[] = sprintf(_MD_CONF_LABEL, $lab).": "._MD_CONFIRM_ERR;
					}
			    }
			    break;
			}
			$this->tag_items[$key]['value'] = $val;
    	}
    	return $errors;
	}
	function tagItems2tag() {
		$ret = "";
		foreach ($this->tag_items as $key=>$item) {
			if (empty($item['field'])) continue;
			$ret .= sprintf( "%s,%s,%s\r\n", $item['label'], $item['type'], $item['value'] );			
    	}
    	return $ret;
	}				
	function tag2itemText() {
		$ret = "";
		foreach ($this->tag_items as $key=>$item) {
			if (empty($item['field'])) continue;
			$ret .= sprintf( "%s: %s<br />", $item['label'], implode(",",$item['options']) );
    	}
    	return $ret;
	}				
}
?>