# --------------------------------------------------------
#
# Table structure for table `goods_category`
#
CREATE TABLE `cartb2b_category` (
  `gcid` int(5) unsigned NOT NULL auto_increment,
  `parent` int(5) unsigned NOT NULL  default '0',
  `weight` smallint(2) default '0',
  `title` varchar(255) NOT NULL default '',
  `image` varchar(255) default NULL,
  `lupdate` int(10) NOT NULL default '0',
  `crtdate` int(10) NOT NULL default '0',
  `content` text default NULL,
  PRIMARY KEY  (`gcid`)
) TYPE=MyISAM AUTO_INCREMENT=1;

# --------------------------------------------------------
#
# Table structure for table `goods`
#
CREATE TABLE `cartb2b_goods` (
  `gid` int(8) unsigned NOT NULL auto_increment,
  `gcid` int(5) unsigned NOT NULL default '0',
  `weight` smallint(2) default '0',
  `visible` tinyint(1) NOT NULL default '1',
  `onsale` tinyint(1) default '1',
  `tag` varchar(255) NOT NULL default '',
  `title` varchar(255) NOT NULL default '',
  `stock` mediumint(8) unsigned default '0',
  `price` DOUBLE(16,2) DEFAULT '0.00' NOT NULL,
  `price1` DOUBLE(16,2) DEFAULT '0.00' NOT NULL,
  `price2` DOUBLE(16,2) DEFAULT '0.00' NOT NULL,
  `price3` DOUBLE(16,2) DEFAULT '0.00' NOT NULL,
  `price4` DOUBLE(16,2) DEFAULT '0.00' NOT NULL,
  `price5` DOUBLE(16,2) DEFAULT '0.00' NOT NULL,
  `image` varchar(255) default NULL,
  `image1` varchar(255) default NULL,
  `image2` varchar(255) default NULL,
  `image3` varchar(255) default NULL,
  `image4` varchar(255) default NULL,
  `image5` varchar(255) default NULL,
  `lupdate` int(10) NOT NULL default '0',
  `crtdate` int(10) NOT NULL default '0',
  `content` text default NULL,
   PRIMARY KEY  (`gid`),
   KEY `gcid` (`gcid`)
) TYPE=MyISAM AUTO_INCREMENT=1;



# --------------------------------------------------------
#
# Table structure for table `cart`
# not buying is just orderid=0
create table cartb2b_cart (
  `cartid` int(8) unsigned NOT NULL auto_increment,
  `uid` mediumint(8) NOT NULL default '0',
  `gid` int(8) unsigned NOT NULL default '0',
  `orderid` int(8) unsigned NOT NULL default '0',
  `qty` mediumint(8) unsigned NOT NULL,
  `price` DOUBLE(16,2) DEFAULT '0.00' NOT NULL,
  `tag` varchar(255) NOT NULL default '',
   PRIMARY KEY (cartid),
   KEY (uid)
) TYPE=MyISAM;

# --------------------------------------------------------
#
# Table structure for table `order`
#
CREATE TABLE `cartb2b_order` (
  `orderid` int(8) unsigned NOT NULL auto_increment,
  `uid` mediumint(8) NOT NULL default '0',
  `order_date` int(10) NOT NULL default '0',
  `sales_person` varchar(48) default NULL,
  `invoice_no` varchar(48) default NULL,
  `invoice_date` int(10) NOT NULL default '0',
  `ship_date` int(10) NOT NULL default '0',
  `firstname` varchar(32) default NULL,
  `lastname` varchar(32) default NULL,
  `areacode` varchar(5) default NULL,
  `phone` varchar(10) default NULL,
  `address` varchar(255) default NULL,
  `address2` varchar(255) default NULL,
  `city` varchar(32) default NULL,
  `state` varchar(32) default NULL,
  `country` varchar(32) default NULL,
  `zipcode` varchar(10) default NULL,
  `carrier` varchar(100) default NULL,
  `tracking_no` varchar(100) default NULL,
  `order_status` smallint(1) unsigned default '0',
  `lupdate` int(10) NOT NULL default '0',
  PRIMARY KEY  (`orderid`),
  KEY `uid` (`uid`)
) TYPE=MyISAM AUTO_INCREMENT=1;
