/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.cb3.accessor.fileaccess.flat;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.co.cybec.cb3.accessor.fileaccess.flat.FlatFileRecord;
import jp.co.cybec.cb3.exception.DataFormatException;
import jp.co.cybec.cb3.util.DateUtil;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlatFileRecordImpl
implements FlatFileRecord {
    private static final Log LOG = LogFactory.getLog(FlatFileRecordImpl.class);
    private static final LogMessageFactory MESSAGE = new LogMessageFactory("logMessage");
    private LinkedHashMap<String, String> fileRecordMap = new LinkedHashMap();

    public FlatFileRecordImpl(LinkedHashMap<String, String> recordMap) {
        this.fileRecordMap.putAll(recordMap);
    }

    @Override
    public String getString(String key) {
        return this.fileRecordMap.get(key);
    }

    @Override
    public BigDecimal getBigDecimal(String key) throws DataFormatException {
        String value;
        block3: {
            value = null;
            try {
                value = this.fileRecordMap.get(key);
                if (value != null && value.length() != 0) break block3;
                return null;
            }
            catch (NumberFormatException e) {
                DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.FLAT.001", "CB3.ACCESSOR.FILEACCESS.005", key, value));
                LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
                throw ex;
            }
        }
        return new BigDecimal(value);
    }

    @Override
    public Double getDouble(String key) throws DataFormatException {
        String value;
        block3: {
            value = null;
            try {
                value = this.fileRecordMap.get(key);
                if (value != null && value.length() != 0) break block3;
                return null;
            }
            catch (NumberFormatException e) {
                DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.FLAT.002", "CB3.ACCESSOR.FILEACCESS.005", key, value));
                LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
                throw ex;
            }
        }
        return Double.valueOf(value);
    }

    @Override
    public Integer getInteger(String key) throws DataFormatException {
        String value;
        block3: {
            value = null;
            try {
                value = this.fileRecordMap.get(key);
                if (value != null && value.length() != 0) break block3;
                return null;
            }
            catch (NumberFormatException e) {
                DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.FLAT.003", "CB3.ACCESSOR.FILEACCESS.005", key, value));
                LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
                throw ex;
            }
        }
        return Integer.valueOf(value);
    }

    @Override
    public Long getLong(String key) throws DataFormatException {
        String value;
        block3: {
            value = null;
            try {
                value = this.fileRecordMap.get(key);
                if (value != null && value.length() != 0) break block3;
                return null;
            }
            catch (NumberFormatException e) {
                DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.FLAT.004", "CB3.ACCESSOR.FILEACCESS.005", key, value));
                LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
                throw ex;
            }
        }
        return Long.valueOf(value);
    }

    @Override
    public Float getFloat(String key) throws DataFormatException {
        String value;
        block3: {
            value = null;
            try {
                value = this.fileRecordMap.get(key);
                if (value != null && value.length() != 0) break block3;
                return null;
            }
            catch (NumberFormatException e) {
                DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.FLAT.005", "CB3.ACCESSOR.FILEACCESS.005", key, value));
                LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
                throw ex;
            }
        }
        return Float.valueOf(value);
    }

    @Override
    public Short getShort(String key) throws DataFormatException {
        String value;
        block3: {
            value = null;
            try {
                value = this.fileRecordMap.get(key);
                if (value != null && value.length() != 0) break block3;
                return null;
            }
            catch (NumberFormatException e) {
                DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.FLAT.006", "CB3.ACCESSOR.FILEACCESS.005", key, value));
                LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
                throw ex;
            }
        }
        return Short.valueOf(value);
    }

    @Override
    public Date getDate(String key) throws DataFormatException {
        String value;
        block3: {
            value = null;
            try {
                value = this.fileRecordMap.get(key);
                if (value != null && value.length() != 0) break block3;
                return null;
            }
            catch (ParseException e) {
                DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.FLAT.007", "CB3.ACCESSOR.FILEACCESS.005", key, value));
                LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
                throw ex;
            }
        }
        return DateUtil.parseDate(value);
    }

    @Override
    public Map<String, String> toMap() {
        return this.fileRecordMap;
    }
}

