/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.cb3.accessor.fileaccess.flat.fixed;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import jp.co.cybec.cb3.accessor.fileaccess.RecordFieldConstants;
import jp.co.cybec.cb3.accessor.fileaccess.RecordFieldReaderFormat;
import jp.co.cybec.cb3.accessor.fileaccess.RecordFieldReaderFormatable;
import jp.co.cybec.cb3.accessor.fileaccess.flat.FlatFileRecord;
import jp.co.cybec.cb3.accessor.fileaccess.flat.FlatFileRecordImpl;
import jp.co.cybec.cb3.accessor.fileaccess.flat.FlatFileRecordReaderImpl;
import jp.co.cybec.cb3.accessor.fileaccess.flat.fixed.FixedLengthRecordFieldConfig;
import jp.co.cybec.cb3.accessor.fileaccess.flat.fixed.FixedLengthRecordReaderConfig;
import jp.co.cybec.cb3.exception.AccessorAlreadyOpenedException;
import jp.co.cybec.cb3.exception.AccessorNotOpenException;
import jp.co.cybec.cb3.exception.ConfigFileDefinitionException;
import jp.co.cybec.cb3.exception.ConfigFileIOException;
import jp.co.cybec.cb3.exception.ConfigFileNotFoundException;
import jp.co.cybec.cb3.exception.ConfigFileParseException;
import jp.co.cybec.cb3.exception.DataFileIOException;
import jp.co.cybec.cb3.exception.DataFileNotFoundException;
import jp.co.cybec.cb3.exception.DataFormatException;
import jp.co.cybec.cb3.util.ConfigurationLoader;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FixedLengthRecordReader
extends FlatFileRecordReaderImpl {
    private static final Log LOG = LogFactory.getLog(FixedLengthRecordReader.class);
    private static final LogMessageFactory MESSAGE = new LogMessageFactory("logMessage");
    private FixedLengthRecordReaderConfig config = null;
    private String ruleFilepath = null;
    private String configFilepath = null;
    private int row = 0;

    public void open(String filepath) throws AccessorAlreadyOpenedException, DataFileNotFoundException, DataFileIOException {
        this.config.setFilepath(filepath);
        super.open(filepath);
    }

    public FlatFileRecord nextRecord() throws AccessorNotOpenException, DataFileIOException, DataFormatException {
        try {
            if (!this.isOpen()) {
                AccessorNotOpenException ex = new AccessorNotOpenException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.FLAT.FIXED.001", "CB3.ACCESSOR.FILEACCESS.001", this.getFilepath()));
                LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
                throw ex;
            }
            String nextLine = super.getBufferedReader().readLine();
            ++this.row;
            return nextLine != null ? this.parseLine(nextLine) : null;
        }
        catch (IOException e) {
            DataFileIOException ex = new DataFileIOException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.FLAT.FIXED.002", "CB3.ACCESSOR.FILEACCESS.004"), e);
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
    }

    public void initialize(String key) throws ConfigFileNotFoundException, ConfigFileDefinitionException, ConfigFileIOException, ConfigFileParseException {
        this.config = (FixedLengthRecordReaderConfig)ConfigurationLoader.load(this.getRuleFilepath(), key);
        this.configFilepath = key;
        if (this.config.getEncode() == null || this.config.getEncode().length() == 0) {
            this.config.setEncode(RecordFieldConstants.SYSTEM_ENCODE);
        }
        super.setFilepath(this.config.getFilepath());
        super.setEncode(this.config.getEncode());
    }

    private FlatFileRecord parseLine(String nextLine) throws IOException, DataFormatException {
        if (nextLine == null || nextLine.length() == 0) {
            return null;
        }
        LinkedHashMap<String, String> recordMap = new LinkedHashMap<String, String>();
        byte[] byteNextLine = nextLine.getBytes(this.config.getEncode());
        List<FixedLengthRecordFieldConfig> fieldList = this.config.getFieldList();
        int offset = 0;
        for (FixedLengthRecordFieldConfig field : fieldList) {
            RecordFieldReaderFormatable fieldFormat;
            int length = Integer.parseInt(field.getLength());
            String value = null;
            try {
                value = new String(byteNextLine, offset, length, this.config.getEncode());
                offset += length;
            }
            catch (IndexOutOfBoundsException e) {
                DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.FLAT.FIXED.003", "CB3.ACCESSOR.FILEACCESS.015", this.configFilepath, this.config.getFilepath()));
                LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
                throw ex;
            }
            if (field.getPatternClass() != null && field.getPatternClass().length() > 0) {
                try {
                    fieldFormat = (RecordFieldReaderFormatable)Class.forName(field.getPatternClass()).newInstance();
                    value = fieldFormat.trim(field.getAlign(), field.getPadding(), value);
                    value = fieldFormat.format(field.getPattern(), field.getType(), value);
                }
                catch (DataFormatException e) {
                    throw e;
                }
                catch (Exception e) {
                    DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.FLAT.FIXED.004", "CB3.ACCESSOR.FILEACCESS.009", field.getPatternClass()));
                    LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
                    throw ex;
                }
            } else {
                fieldFormat = new RecordFieldReaderFormat(this.configFilepath, field.getName());
                value = ((RecordFieldReaderFormat)fieldFormat).trim(field.getAlign(), field.getPadding(), value);
                value = ((RecordFieldReaderFormat)fieldFormat).format(field.getPattern(), field.getType(), value);
            }
            recordMap.put(field.getName(), value);
        }
        if (offset != byteNextLine.length) {
            DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.FLAT.FIXED.005", "CB3.ACCESSOR.FILEACCESS.015", this.configFilepath, this.config.getFilepath()));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        return new FlatFileRecordImpl(recordMap);
    }

    public String getRuleFilepath() {
        if (this.ruleFilepath == null) {
            this.ruleFilepath = "FixedLengthRecordReaderRule.xml";
        }
        return this.ruleFilepath;
    }

    public void setRuleFilepath(String path) {
        this.ruleFilepath = path;
    }
}

