/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.cb3.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateUtil {
    public static final String DEFAUL_PATTERN = "yyyy/MM/dd HH:mm:ss";
    public static final String DEFAUL_TIMESTAMP_PATTERN = "yyyy/MM/dd HH:mm:ss.SSS";

    public static Date parseDate(String value) throws ParseException {
        return DateUtil.parseDate(value, DEFAUL_PATTERN, true);
    }

    public static Date parseDate(String value, String format) throws ParseException {
        return DateUtil.parseDate(value, format, true);
    }

    public static Date parseDate(String value, String format, boolean lenient) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat(format);
        df.setLenient(lenient);
        return value != null ? df.parse(value) : null;
    }

    public static String formatDate(Date date) throws IllegalArgumentException {
        return DateUtil.formatDate(date, DEFAUL_PATTERN);
    }

    public static String formatDate(Date date, String format) throws IllegalArgumentException {
        if (date == null) {
            return null;
        }
        SimpleDateFormat df = format != null ? new SimpleDateFormat(format) : new SimpleDateFormat(DEFAUL_PATTERN);
        return format != null ? df.format(date) : df.format(date);
    }

    public static String formatTimestamp(Timestamp timestamp) throws IllegalArgumentException {
        return DateUtil.formatTimestamp(timestamp, DEFAUL_TIMESTAMP_PATTERN);
    }

    public static String formatTimestamp(Timestamp timestamp, String format) throws IllegalArgumentException {
        if (timestamp == null) {
            return null;
        }
        SimpleDateFormat df = format != null ? new SimpleDateFormat(format) : new SimpleDateFormat(DEFAUL_TIMESTAMP_PATTERN);
        return format != null ? df.format(timestamp) : df.format(timestamp);
    }
}

