/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.cb3.util;

import java.net.URL;
import jp.co.cybec.cb3.exception.ConfigFileDefinitionException;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ValidationEntityResolver
implements EntityResolver {
    private static final LogMessageFactory MESSAGE = new LogMessageFactory("logMessage");
    private static final String SCHEMA_FILE_PATH = "schema/";
    private URL xmlFile = null;

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, ConfigFileDefinitionException {
        String entityURL = null;
        if (publicId != null) {
            entityURL = publicId;
        }
        if (entityURL == null && systemId != null) {
            entityURL = systemId.substring(systemId.lastIndexOf(47) + 1);
        }
        if (entityURL == null) {
            throw new ConfigFileDefinitionException(MESSAGE.getErrorMessage("UTIL.009", "CB3.UTIL.001", this.xmlFile, ".xsd"));
        }
        URL url = ValidationEntityResolver.class.getClassLoader().getResource(SCHEMA_FILE_PATH + entityURL);
        if (url == null) {
            throw new ConfigFileDefinitionException(MESSAGE.getErrorMessage("UTIL.010", "CB3.UTIL.001", this.xmlFile, entityURL));
        }
        try {
            return new InputSource(url.toString());
        }
        catch (Exception e) {
            throw new ConfigFileDefinitionException(MESSAGE.getErrorMessage("UTIL.011", "CB3.UTIL.001", this.xmlFile, entityURL), e);
        }
    }

    public void setXmlFile(URL xmlFile) {
        this.xmlFile = xmlFile;
    }
}

