/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.cb3.accessor.dbaccess;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import jp.co.cybec.cb3.accessor.dbaccess.ParsedSql;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.JdbcUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CB3JdbcTemplate {
    private static final Log LOG = LogFactory.getLog(CB3JdbcTemplate.class);
    private static final LogMessageFactory MESSAGE = new LogMessageFactory("logMessage");
    private static final char[] PARAMETER_SEPARATORS = new char[]{'\"', '\'', ':', '&', ',', ';', '(', ')', '|', '=', '+', '-', '*', '%', '/', '\\', '<', '>', '^'};
    private JdbcTemplate jdbcTemplate = null;
    private Map<String, PreparedStatement> preparedStatementCache = new HashMap<String, PreparedStatement>();
    private Map<String, ParsedSql> parsedSqlCache = new HashMap<String, ParsedSql>();
    private Connection con = null;

    public CB3JdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void close() {
        for (String key : this.preparedStatementCache.keySet()) {
            if (this.preparedStatementCache.get(key) == null) continue;
            JdbcUtils.closeStatement((Statement)this.preparedStatementCache.get(key));
        }
        if (this.con != null) {
            DataSourceUtils.releaseConnection((Connection)this.con, (DataSource)this.getJdbcTemplate().getDataSource());
            this.con = null;
        }
        this.preparedStatementCache.clear();
    }

    public ResultSet query(String sql, Map<String, Object> parameter) throws DataAccessException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)MESSAGE.getMessage("CB3.ACCESSOR.DBACCESS.012", sql, parameter));
        }
        try {
            this.con = this.getConnection();
            PreparedStatement ps = this.getPreparedStatement(sql, parameter);
            ResultSet rs = ps.executeQuery();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)MESSAGE.getMessage("CB3.ACCESSOR.DBACCESS.013"));
            }
            return rs;
        }
        catch (SQLException e) {
            Object[] msg = new Object[]{sql, parameter};
            DataAccessException ex = this.jdbcTemplate.getExceptionTranslator().translate(MESSAGE.getErrorMessage("ACCESSOR.DBACCESS.001", "CB3.ACCESSOR.DBACCESS.001", msg), sql, e);
            LOG.info((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    public ResultSet query(String sql) throws DataAccessException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)MESSAGE.getMessage("CB3.ACCESSOR.DBACCESS.012", sql, ""));
        }
        try {
            this.con = this.getConnection();
            PreparedStatement ps = this.getPreparedStatement(sql, null);
            ResultSet rs = ps.executeQuery();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)MESSAGE.getMessage("CB3.ACCESSOR.DBACCESS.013"));
            }
            return rs;
        }
        catch (SQLException e) {
            Object[] msg = new Object[]{sql, ""};
            DataAccessException ex = this.jdbcTemplate.getExceptionTranslator().translate(MESSAGE.getErrorMessage("ACCESSOR.DBACCESS.002", "CB3.ACCESSOR.DBACCESS.001", msg), sql, e);
            LOG.info((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    public int update(String sql, Map<String, Object> parameter) throws DataAccessException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)MESSAGE.getMessage("CB3.ACCESSOR.DBACCESS.012", sql, parameter));
        }
        try {
            this.con = this.getConnection();
            PreparedStatement ps = this.getPreparedStatement(sql, parameter);
            int recordNumber = ps.executeUpdate();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)MESSAGE.getMessage("CB3.ACCESSOR.DBACCESS.014", recordNumber));
            }
            return recordNumber;
        }
        catch (SQLException e) {
            Object[] msg = new Object[]{sql, parameter};
            DataAccessException ex = this.jdbcTemplate.getExceptionTranslator().translate(MESSAGE.getErrorMessage("ACCESSOR.DBACCESS.003", "CB3.ACCESSOR.DBACCESS.001", msg), sql, e);
            LOG.info((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    public int update(String sql) throws DataAccessException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)MESSAGE.getMessage("CB3.ACCESSOR.DBACCESS.012", sql, ""));
        }
        try {
            this.con = this.getConnection();
            PreparedStatement ps = this.getPreparedStatement(sql, null);
            int recordNumber = ps.executeUpdate();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)MESSAGE.getMessage("CB3.ACCESSOR.DBACCESS.014", recordNumber));
            }
            return recordNumber;
        }
        catch (SQLException e) {
            Object[] msg = new Object[]{sql, ""};
            DataAccessException ex = this.jdbcTemplate.getExceptionTranslator().translate(MESSAGE.getErrorMessage("ACCESSOR.DBACCESS.004", "CB3.ACCESSOR.DBACCESS.001", msg), sql, e);
            LOG.info((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    public void commit() throws DataAccessException {
        try {
            this.con = this.getConnection();
            this.con.commit();
        }
        catch (SQLException e) {
            DataAccessException ex = this.jdbcTemplate.getExceptionTranslator().translate(MESSAGE.getErrorMessage("ACCESSOR.DBACCESS.005", "CB3.ACCESSOR.DBACCESS.002"), "", e);
            LOG.info((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    private Connection getConnection() {
        if (this.con == null) {
            this.con = DataSourceUtils.getConnection((DataSource)this.getJdbcTemplate().getDataSource());
        }
        return this.con;
    }

    private PreparedStatement getPreparedStatement(String sql, Map<String, Object> parameter) throws SQLException {
        PreparedStatement ps;
        ParsedSql parsedSql = this.parsedSqlCache.get(sql);
        if (parsedSql == null) {
            parsedSql = this.parseSql(sql);
            this.parsedSqlCache.put(sql, parsedSql);
        }
        if ((ps = this.preparedStatementCache.get(sql)) == null) {
            ps = this.con.prepareStatement(parsedSql.getSql());
            this.preparedStatementCache.put(sql, ps);
        }
        ps.clearParameters();
        if (parameter == null || parameter.size() == 0) {
            return ps;
        }
        parsedSql.getParameterNames();
        ArrayList<Object> paramValues = new ArrayList<Object>();
        int paramIndex = 1;
        for (String paramName : parsedSql.getParameterNames()) {
            Object value = parameter.get(paramName);
            ps.setObject(paramIndex, value);
            paramValues.add(value);
            ++paramIndex;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)MESSAGE.getMessage("CB3.ACCESSOR.DBACCESS.007", parsedSql.getSql(), paramValues));
        }
        return ps;
    }

    private ParsedSql parseSql(String sql) {
        ParsedSql parsedSql = new ParsedSql();
        char[] originalSql = sql.toCharArray();
        boolean withinQuotes = false;
        char currentQuote = '-';
        StringBuilder compiledSql = new StringBuilder();
        int i = 0;
        while (i < originalSql.length) {
            char c = originalSql[i];
            if (withinQuotes) {
                compiledSql.append(c);
                if (c == currentQuote) {
                    withinQuotes = false;
                    currentQuote = '-';
                }
            } else if (c == '\"' || c == '\'') {
                compiledSql.append(c);
                withinQuotes = true;
                currentQuote = c;
            } else if (c == ':' || c == '&') {
                int j = i + 1;
                if (j < originalSql.length && originalSql[j] == ':' && c == ':') {
                    i += 2;
                    continue;
                }
                while (j < originalSql.length && !this.isParameterSeparator(originalSql[j])) {
                    ++j;
                }
                if (j - i > 1) {
                    String parameter = sql.substring(i + 1, j);
                    parsedSql.addParameterNames(parameter);
                    compiledSql.append('?');
                }
                i = j - 1;
            } else {
                compiledSql.append(c);
            }
            ++i;
        }
        parsedSql.setSql(compiledSql.toString());
        return parsedSql;
    }

    private boolean isParameterSeparator(char c) {
        if (Character.isWhitespace(c)) {
            return true;
        }
        for (int i = 0; i < PARAMETER_SEPARATORS.length; ++i) {
            if (c != PARAMETER_SEPARATORS[i]) continue;
            return true;
        }
        return false;
    }
}

