/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.cb3.accessor.dbaccess;

import java.sql.ResultSet;
import java.sql.SQLException;
import jp.co.cybec.cb3.accessor.dbaccess.DBQueryParameterMap;
import jp.co.cybec.cb3.accessor.dbaccess.DBRecord;
import jp.co.cybec.cb3.accessor.dbaccess.DBRecordReader;
import jp.co.cybec.cb3.accessor.dbaccess.JdbcRecord;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.support.SQLStateSQLExceptionTranslator;

public class JdbcRecordReader
implements DBRecordReader {
    private static final Log LOG = LogFactory.getLog(JdbcRecordReader.class);
    private ResultSet resultSet = null;
    private static final LogMessageFactory MESSAGE = new LogMessageFactory("logMessage");
    private String sql = null;
    private DBQueryParameterMap parameter = null;
    private int row = 0;

    public JdbcRecordReader(ResultSet rs, String sql, DBQueryParameterMap parameter) {
        this.resultSet = rs;
        this.sql = sql;
        this.parameter = parameter;
    }

    public JdbcRecordReader(ResultSet rs, String sql) {
        this(rs, sql, null);
    }

    public DBRecord nextRecord() throws DataAccessException {
        JdbcRecord record = null;
        ++this.row;
        try {
            if (this.resultSet.next()) {
                record = new JdbcRecord(this.resultSet, this.sql, this.parameter, this.row);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)MESSAGE.getMessage("CB3.ACCESSOR.DBACCESS.015", this.row, record.toMap()));
                }
            } else {
                record = null;
            }
        }
        catch (SQLException e) {
            String stringOfParameter = this.parameter == null ? "" : this.parameter.toString();
            DataAccessException ex = new SQLStateSQLExceptionTranslator().translate(MESSAGE.getErrorMessage("ACCESSOR.DBACCESS.030", "CB3.ACCESSOR.DBACCESS.004", this.sql, stringOfParameter, this.row), "", e);
            LOG.info((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        return record;
    }

    public void close() {
        try {
            this.resultSet.close();
        }
        catch (SQLException e) {
            String stringOfParameter = this.parameter == null ? "" : this.parameter.toString();
            DataAccessException ex = new SQLStateSQLExceptionTranslator().translate(MESSAGE.getErrorMessage("ACCESSOR.DBACCESS.030", "CB3.ACCESSOR.DBACCESS.001", this.sql, stringOfParameter, this.row), "", e);
            LOG.info((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }
}

