/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.cb3.accessor.fileaccess.flat;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import jp.co.cybec.cb3.accessor.AccessorsLifeCycle;
import jp.co.cybec.cb3.accessor.fileaccess.flat.FlatFileRecord;
import jp.co.cybec.cb3.accessor.fileaccess.flat.FlatFileRecordReader;
import jp.co.cybec.cb3.exception.AccessorAlreadyOpenedException;
import jp.co.cybec.cb3.exception.AccessorNotOpenException;
import jp.co.cybec.cb3.exception.DataFileIOException;
import jp.co.cybec.cb3.exception.DataFileNotFoundException;
import jp.co.cybec.cb3.exception.DataFormatException;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FlatFileRecordReaderImpl
implements FlatFileRecordReader,
AccessorsLifeCycle {
    private static final Log LOG = LogFactory.getLog(FlatFileRecordReaderImpl.class);
    private static final LogMessageFactory MESSAGE = new LogMessageFactory("logMessage");
    private String filepath = null;
    private BufferedReader reader = null;
    private boolean isOpen = false;
    private String encode = null;

    public void open() throws AccessorAlreadyOpenedException, DataFileNotFoundException, DataFileIOException {
        if (this.isOpen) {
            AccessorAlreadyOpenedException ex = new AccessorAlreadyOpenedException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.FLAT.008", "CB3.ACCESSOR.FILEACCESS.002", this.filepath));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        if (this.filepath == null || this.filepath.length() == 0) {
            DataFileNotFoundException ex = new DataFileNotFoundException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.FLAT.016", "CB3.ACCESSOR.FILEACCESS.018"));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        try {
            this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(this.filepath)), this.encode));
            this.isOpen = true;
        }
        catch (FileNotFoundException e) {
            DataFileNotFoundException ex = new DataFileNotFoundException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.FLAT.009", "CB3.ACCESSOR.FILEACCESS.003", this.filepath), e);
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        catch (IOException e) {
            DataFileIOException ex = new DataFileIOException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.FLAT.010", "CB3.ACCESSOR.FILEACCESS.004", this.filepath), e);
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
    }

    public void open(String filepath) throws AccessorAlreadyOpenedException, DataFileNotFoundException, DataFileIOException {
        this.filepath = filepath;
        this.open();
    }

    public FlatFileRecord nextRecord() throws AccessorNotOpenException, DataFileIOException, DataFormatException {
        return null;
    }

    public void close() throws DataFileIOException {
        if (this.isOpen) {
            try {
                this.reader.close();
                this.reader = null;
                this.isOpen = false;
            }
            catch (IOException e) {
                DataFileIOException ex = new DataFileIOException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.FLAT.011", "CB3.ACCESSOR.FILEACCESS.004", this.filepath), e);
                LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
                throw ex;
            }
        }
    }

    public void initialize(String key) {
    }

    public void release() {
        this.close();
    }

    protected String getFilepath() {
        return this.filepath;
    }

    protected void setFilepath(String filepath) {
        this.filepath = filepath;
    }

    protected BufferedReader getBufferedReader() {
        return this.reader;
    }

    protected boolean isOpen() {
        return this.isOpen;
    }

    protected String getEncode() {
        return this.encode;
    }

    protected void setEncode(String encode) {
        this.encode = encode;
    }
}

