/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.cb3.accessor.fileaccess.xml;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import jp.co.cybec.cb3.accessor.AccessorsLifeCycle;
import jp.co.cybec.cb3.accessor.fileaccess.xml.XMLFileReader;
import jp.co.cybec.cb3.accessor.fileaccess.xml.XMLFileReaderConfig;
import jp.co.cybec.cb3.accessor.fileaccess.xml.XMLPath;
import jp.co.cybec.cb3.exception.AccessorAlreadyOpenedException;
import jp.co.cybec.cb3.exception.AccessorNotOpenException;
import jp.co.cybec.cb3.exception.ConfigFileDefinitionException;
import jp.co.cybec.cb3.exception.ConfigFileIOException;
import jp.co.cybec.cb3.exception.ConfigFileNotFoundException;
import jp.co.cybec.cb3.exception.ConfigFileParseException;
import jp.co.cybec.cb3.exception.DataFileIOException;
import jp.co.cybec.cb3.exception.DataFileNotFoundException;
import jp.co.cybec.cb3.exception.DataFileParseException;
import jp.co.cybec.cb3.util.ConfigurationLoader;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public class XMLFileReaderImpl
implements XMLFileReader,
AccessorsLifeCycle {
    private static final Log LOG = LogFactory.getLog(XMLFileReaderImpl.class);
    private static final LogMessageFactory MESSAGE = new LogMessageFactory("logMessage");
    private static final String XML_FILE_READER_RULE_FILE_NAME = "XMLFileReaderRule.xml";
    private String key = null;
    private XMLFileReaderConfig config = null;
    private boolean isOpen = false;
    private BufferedInputStream stream = null;
    private XmlObject xml = null;

    public XMLPath selectPath(String path) throws AccessorNotOpenException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)MESSAGE.getMessage("CB3.ACCESSOR.FILEACCESS.XML.007", this.key, path));
        }
        if (!this.isOpen) {
            AccessorNotOpenException ex = new AccessorNotOpenException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.013", "CB3.ACCESSOR.FILEACCESS.001", this.key));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        return new XMLPath(this.key, this.xml, path);
    }

    public void open() throws AccessorAlreadyOpenedException, DataFileNotFoundException, DataFileParseException, DataFileIOException {
        if (this.isOpen) {
            AccessorAlreadyOpenedException ex = new AccessorAlreadyOpenedException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.014", "CB3.ACCESSOR.FILEACCESS.002", this.key));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        if (this.config.getFilepath() == null || this.config.getFilepath().length() == 0) {
            DataFileNotFoundException ex = new DataFileNotFoundException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.041", "CB3.ACCESSOR.FILEACCESS.018"));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        try {
            File file = new File(this.config.getFilepath());
            this.stream = new BufferedInputStream(new FileInputStream(file));
            this.xml = XmlObject.Factory.parse((InputStream)this.stream);
            this.isOpen = true;
        }
        catch (FileNotFoundException e) {
            DataFileNotFoundException ex = new DataFileNotFoundException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.015", "CB3.ACCESSOR.FILEACCESS.003", this.config.getFilepath()), e);
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        catch (IOException e) {
            DataFileIOException ex = new DataFileIOException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.016", "CB3.ACCESSOR.FILEACCESS.004", this.config.getFilepath()), e);
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        catch (XmlException e) {
            DataFileParseException ex = new DataFileParseException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.017", "CB3.ACCESSOR.FILEACCESS.XML.001", this.config.getFilepath()), (Exception)((Object)e));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
    }

    public void open(String filepath) throws AccessorAlreadyOpenedException, DataFileNotFoundException, DataFileParseException, DataFileIOException {
        this.config.setFilepath(filepath);
        this.open();
    }

    public void close() throws DataFileIOException {
        if (this.isOpen) {
            try {
                this.stream.close();
                this.xml = null;
                this.stream = null;
                this.isOpen = false;
            }
            catch (IOException e) {
                throw new DataFileIOException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.018", "CB3.ACCESSOR.FILEACCESS.004", this.config.getFilepath()), e);
            }
        }
    }

    public void initialize(String key) throws ConfigFileNotFoundException, ConfigFileDefinitionException, ConfigFileIOException, ConfigFileParseException {
        this.key = key;
        this.config = (XMLFileReaderConfig)ConfigurationLoader.load(XML_FILE_READER_RULE_FILE_NAME, key);
    }

    public void release() throws DataFileIOException {
        this.close();
    }
}

