/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.cb3.accessor.fileaccess.xml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import jp.co.cybec.cb3.accessor.AccessorsLifeCycle;
import jp.co.cybec.cb3.accessor.fileaccess.xml.XMLAttribute;
import jp.co.cybec.cb3.accessor.fileaccess.xml.XMLElement;
import jp.co.cybec.cb3.accessor.fileaccess.xml.XMLFileWriter;
import jp.co.cybec.cb3.accessor.fileaccess.xml.XMLFileWriterConfig;
import jp.co.cybec.cb3.exception.AccessorAlreadyOpenedException;
import jp.co.cybec.cb3.exception.AccessorNotOpenException;
import jp.co.cybec.cb3.exception.AccessorRuntimeException;
import jp.co.cybec.cb3.exception.AccessorUnknownException;
import jp.co.cybec.cb3.exception.BadXmlGrammerException;
import jp.co.cybec.cb3.exception.ConfigFileDefinitionException;
import jp.co.cybec.cb3.exception.ConfigFileIOException;
import jp.co.cybec.cb3.exception.ConfigFileNotFoundException;
import jp.co.cybec.cb3.exception.ConfigFileParseException;
import jp.co.cybec.cb3.exception.DataFileIOException;
import jp.co.cybec.cb3.exception.DataFileNotFoundException;
import jp.co.cybec.cb3.util.ConfigurationLoader;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public class XMLFileWriterImpl
implements XMLFileWriter,
AccessorsLifeCycle {
    private static final Log LOG = LogFactory.getLog(XMLFileWriterImpl.class);
    private static final LogMessageFactory MESSAGE = new LogMessageFactory("logMessage");
    private static final String XML_FILE_WRITER_RULE_FILE_NAME = "XMLFileWriterRule.xml";
    private static final String DEFAULT_LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String DEFAULT_ENCODE = "UTF-8";
    private static final Object SEEN_NOTHING = new Object();
    private static final Object SEEN_ELEMENT = new Object();
    private static final Object SEEN_DATA = new Object();
    private String key = null;
    private XMLFileWriterConfig config = null;
    private boolean isOpen = false;
    private OutputStreamWriter writer = null;
    private Object state = SEEN_NOTHING;
    private Stack<Object> stateStack = new Stack();
    private int indentSpace = 2;
    private int depth = 0;
    private Map<String, String> prefixMap = null;
    private Map<String, Boolean> namespaceMap = null;
    private Map<String, String> declaredNamespaceMap = null;
    private NamespaceSupport nsSupport = null;

    public void startElement(XMLElement element) throws AccessorNotOpenException, DataFileIOException {
        if (!this.isOpen) {
            AccessorNotOpenException ex = new AccessorNotOpenException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.019", "CB3.ACCESSOR.FILEACCESS.001", this.key));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        try {
            this.startElement(element.getURI(), element.getName(), element.getQName(), this.getAttributes(element));
        }
        catch (AccessorRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            AccessorUnknownException ex = new AccessorUnknownException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.020", "CB3.ACCESSOR.FILEACCESS.006", this.key), e);
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
    }

    public void endElement(XMLElement element) throws AccessorNotOpenException, BadXmlGrammerException, DataFileIOException {
        if (!this.isOpen) {
            AccessorNotOpenException ex = new AccessorNotOpenException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.021", "CB3.ACCESSOR.FILEACCESS.001", this.key));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        try {
            this.endElement(element.getURI(), element.getName(), element.getQName());
        }
        catch (AccessorRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            AccessorUnknownException ex = new AccessorUnknownException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.022", "CB3.ACCESSOR.FILEACCESS.006", this.key), e);
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
    }

    public void dataElement(XMLElement element) throws AccessorNotOpenException, DataFileIOException {
        if (!this.isOpen) {
            AccessorNotOpenException ex = new AccessorNotOpenException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.023", "CB3.ACCESSOR.FILEACCESS.001", this.key));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        try {
            this.dataElement(element.getURI(), element.getName(), element.getQName(), this.getAttributes(element), element.getString());
        }
        catch (AccessorRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            AccessorUnknownException ex = new AccessorUnknownException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.024", "CB3.ACCESSOR.FILEACCESS.006", this.key), e);
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
    }

    public void characters(XMLElement element) throws AccessorNotOpenException, DataFileIOException {
        if (!this.isOpen) {
            AccessorNotOpenException ex = new AccessorNotOpenException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.025", "CB3.ACCESSOR.FILEACCESS.001", this.key));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        try {
            this.characters(element.getString());
        }
        catch (AccessorRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            AccessorUnknownException ex = new AccessorUnknownException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.026", "CB3.ACCESSOR.FILEACCESS.006", this.key), e);
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
    }

    public void open() throws AccessorAlreadyOpenedException, DataFileNotFoundException, DataFileIOException {
        if (this.isOpen) {
            AccessorAlreadyOpenedException ex = new AccessorAlreadyOpenedException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.027", "CB3.ACCESSOR.FILEACCESS.002", this.key));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        if (this.config.getFilepath() == null || this.config.getFilepath().length() == 0) {
            DataFileNotFoundException ex = new DataFileNotFoundException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.042", "CB3.ACCESSOR.FILEACCESS.018"));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        try {
            File file = new File(this.config.getFilepath());
            this.writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.config.getEncode());
            this.init();
            this.startDocument();
            this.isOpen = true;
        }
        catch (FileNotFoundException e) {
            DataFileNotFoundException ex = new DataFileNotFoundException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.028", "CB3.ACCESSOR.FILEACCESS.003", this.config.getFilepath()), e);
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        catch (IOException e) {
            DataFileIOException ex = new DataFileIOException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.029", "CB3.ACCESSOR.FILEACCESS.004", this.config.getFilepath()), e);
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
    }

    public void open(String filepath) throws AccessorAlreadyOpenedException, DataFileNotFoundException, DataFileIOException {
        this.config.setFilepath(filepath);
        this.open();
    }

    public void close() throws DataFileIOException {
        if (this.isOpen) {
            try {
                this.endDocument();
                this.writer.flush();
                this.writer.close();
                this.writer = null;
                this.isOpen = false;
            }
            catch (IOException e) {
                DataFileIOException ex = new DataFileIOException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.030", "CB3.ACCESSOR.FILEACCESS.004", this.config.getFilepath()), e);
                LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
                throw ex;
            }
        }
    }

    public void initialize(String key) throws ConfigFileNotFoundException, ConfigFileDefinitionException, ConfigFileIOException, ConfigFileParseException {
        this.key = key;
        this.config = (XMLFileWriterConfig)ConfigurationLoader.load(XML_FILE_WRITER_RULE_FILE_NAME, key);
        if (this.config.getLineSeparator() == null || this.config.getLineSeparator().length() == 0) {
            this.config.setLineSeparator(DEFAULT_LINE_SEPARATOR);
        } else {
            this.config.setLineSeparator(this.config.getLineSeparator().replaceAll("\\\\r", "\r"));
            this.config.setLineSeparator(this.config.getLineSeparator().replaceAll("\\\\n", "\n"));
        }
        if (this.config.getEncode() == null || this.config.getEncode().length() == 0) {
            this.config.setEncode(DEFAULT_ENCODE);
        }
        if (this.config.getIndentSpace() != null && this.config.getIndentSpace().length() > 0) {
            this.indentSpace = Integer.parseInt(this.config.getIndentSpace());
        }
    }

    public void release() throws DataFileIOException {
        this.close();
    }

    public void addNamespace(String uri, String prefix) throws AccessorNotOpenException {
        if (!this.isOpen) {
            AccessorNotOpenException ex = new AccessorNotOpenException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.031", "CB3.ACCESSOR.FILEACCESS.001", this.key));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        this.prefixMap.put(uri, prefix);
        this.addNamespace(uri);
    }

    public void addNamespace(String uri) throws AccessorNotOpenException {
        if (!this.isOpen) {
            AccessorNotOpenException ex = new AccessorNotOpenException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.032", "CB3.ACCESSOR.FILEACCESS.001", this.key));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        this.namespaceMap.put(uri, Boolean.TRUE);
    }

    private void startDocument() throws DataFileIOException {
        this.write("<?xml version=\"1.0\" encoding=\"");
        this.write(this.config.getEncode());
        this.write("\"?>");
        this.write(this.config.getLineSeparator());
        this.write(this.config.getLineSeparator());
    }

    private void endDocument() throws DataFileIOException {
        this.write(this.config.getLineSeparator());
    }

    private void startElement(String uri, String localName, String qName, Attributes atts) throws DataFileIOException {
        this.stateStack.push(SEEN_ELEMENT);
        this.state = SEEN_NOTHING;
        if (this.depth > 0) {
            this.characters(this.config.getLineSeparator());
        }
        this.doIndent();
        this.nsSupport.pushContext();
        this.write('<');
        this.writeName(uri, localName, qName, true);
        this.writeAttributes(atts);
        if (this.depth == 0) {
            this.declareNamespace();
        }
        this.writeNSDecls();
        this.write('>');
        ++this.depth;
    }

    private void endElement(String uri, String localName, String qName) throws BadXmlGrammerException, DataFileIOException {
        if (this.depth == 0) {
            BadXmlGrammerException ex = new BadXmlGrammerException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.033", "CB3.ACCESSOR.FILEACCESS.XML.006", this.key, localName));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        --this.depth;
        if (this.state == SEEN_ELEMENT) {
            this.characters(this.config.getLineSeparator());
            this.doIndent();
        }
        this.write("</");
        this.writeName(uri, localName, qName, true);
        this.write('>');
        this.nsSupport.popContext();
        this.state = this.stateStack.pop();
    }

    private void dataElement(String uri, String localName, String qName, Attributes atts, String content) throws DataFileIOException {
        this.startElement(uri, localName, qName, atts);
        this.characters(content);
        this.endElement(uri, localName, qName);
    }

    private void characters(String data) throws DataFileIOException {
        String writeData = data;
        if (writeData == null) {
            writeData = "";
        }
        char[] ch = writeData.toCharArray();
        this.characters(ch, 0, ch.length);
    }

    private void characters(char[] ch, int start, int len) throws DataFileIOException {
        this.state = SEEN_DATA;
        this.writeEsc(ch, start, len, false);
    }

    private void init() {
        this.depth = 0;
        this.state = SEEN_NOTHING;
        this.stateStack = new Stack();
        this.prefixMap = new HashMap<String, String>();
        this.namespaceMap = new LinkedHashMap<String, Boolean>();
        this.declaredNamespaceMap = new HashMap<String, String>();
        this.nsSupport = new NamespaceSupport();
    }

    private void declareNamespace() {
        for (String uri : this.namespaceMap.keySet()) {
            this.doPrefix(uri, null, true);
        }
    }

    private String doPrefix(String uri, String qName, boolean isElement) {
        if (uri == null || uri.length() == 0) {
            return null;
        }
        String prefix = this.nsSupport.getPrefix(uri);
        if (prefix != null) {
            return prefix;
        }
        prefix = this.declaredNamespaceMap.get(uri);
        if (prefix != null) {
            return prefix;
        }
        prefix = this.prefixMap.get(uri);
        if (prefix == null && qName != null && !"".equals(qName)) {
            int i = qName.indexOf(58);
            if (i == -1) {
                return null;
            }
            prefix = qName.substring(0, i);
        }
        if (prefix == null) {
            prefix = "";
        }
        this.nsSupport.declarePrefix(prefix, uri);
        this.declaredNamespaceMap.put(uri, prefix);
        return prefix;
    }

    private void write(char c) throws DataFileIOException {
        try {
            this.writer.write(c);
        }
        catch (IOException e) {
            DataFileIOException ex = new DataFileIOException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.034", "CB3.ACCESSOR.FILEACCESS.004", this.config.getFilepath()), e);
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
    }

    private void write(String s) throws DataFileIOException {
        try {
            this.writer.write(s);
        }
        catch (IOException e) {
            DataFileIOException ex = new DataFileIOException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.035", "CB3.ACCESSOR.FILEACCESS.004", this.config.getFilepath()), e);
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
    }

    private void writeAttributes(Attributes atts) throws DataFileIOException {
        int len = atts.getLength();
        for (int i = 0; i < len; ++i) {
            char[] ch = atts.getValue(i).toCharArray();
            this.write(' ');
            this.writeName(atts.getURI(i), atts.getLocalName(i), atts.getQName(i), false);
            this.write("=\"");
            this.writeEsc(ch, 0, ch.length, true);
            this.write('\"');
        }
    }

    private void writeEsc(char[] ch, int start, int length, boolean isAttVal) throws DataFileIOException {
        block6: for (int i = start; i < start + length; ++i) {
            switch (ch[i]) {
                case '&': {
                    this.write("&amp;");
                    continue block6;
                }
                case '<': {
                    this.write("&lt;");
                    continue block6;
                }
                case '>': {
                    this.write("&gt;");
                    continue block6;
                }
                case '\"': {
                    if (isAttVal) {
                        this.write("&quot;");
                        continue block6;
                    }
                    this.write('\"');
                    continue block6;
                }
                default: {
                    this.write(ch[i]);
                }
            }
        }
    }

    private void writeNSDecls() throws DataFileIOException {
        Enumeration<String> prefixes = this.nsSupport.getDeclaredPrefixes();
        while (prefixes.hasMoreElements()) {
            String prefix = prefixes.nextElement();
            String uri = this.nsSupport.getURI(prefix);
            char[] ch = uri.toCharArray();
            this.write(' ');
            if ("".equals(prefix)) {
                this.write("xmlns=\"");
            } else {
                this.write("xmlns:");
                this.write(prefix);
                this.write("=\"");
            }
            this.writeEsc(ch, 0, ch.length, true);
            this.write('\"');
        }
    }

    private void writeName(String uri, String localName, String qName, boolean isElement) throws DataFileIOException {
        String prefix = this.doPrefix(uri, qName, isElement);
        if (prefix != null && !"".equals(prefix)) {
            this.write(prefix);
            this.write(':');
        }
        this.write(localName);
    }

    private void doIndent() throws DataFileIOException {
        if (this.indentSpace > 0 && this.depth > 0) {
            int n = this.indentSpace * this.depth;
            char[] ch = new char[n];
            for (int i = 0; i < n; ++i) {
                ch[i] = 32;
            }
            this.characters(ch, 0, n);
        }
    }

    private Attributes getAttributes(XMLElement element) {
        AttributesImpl attributes = new AttributesImpl();
        for (XMLAttribute attribute : element.getAttributes().values()) {
            attributes.addAttribute(attribute.getURI(), attribute.getName(), attribute.getQName(), "CDATA", attribute.getString());
        }
        return attributes;
    }
}

