/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.cb3.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;

public class NumberUtil {
    public static int getFractionDigits(String value) {
        int place = 0;
        if (value != null && value.length() > 0) {
            String strVal = value.trim();
            place = strVal.lastIndexOf(46) == -1 ? 0 : strVal.length() - strVal.lastIndexOf(46) - 1;
        }
        return place;
    }

    public static BigDecimal parseBigDecimal(String pattern, String value) throws NullPointerException, IllegalArgumentException, ParseException {
        DecimalFormat df = new DecimalFormat();
        df.applyPattern(pattern);
        df.setParseBigDecimal(true);
        return (BigDecimal)df.parse(value);
    }

    public static String formatNumber(String pattern, String value) throws NullPointerException, IllegalArgumentException {
        DecimalFormat df = new DecimalFormat();
        df.applyPattern(pattern);
        return df.format(new BigDecimal(value));
    }

    public static String numberToString(BigDecimal value, int fractionDigits) {
        if (value == null) {
            return null;
        }
        DecimalFormat df = new DecimalFormat();
        df.setGroupingUsed(false);
        df.setMaximumFractionDigits(fractionDigits);
        return df.format(value);
    }
}

