/*
 * DBAccess.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.sample.database.dbaccess;

import jp.co.cybec.cb3.accessor.dbaccess.DBAccessor;
import jp.co.cybec.cb3.accessor.dbaccess.DBRecord;
import jp.co.cybec.cb3.accessor.dbaccess.DBRecordReader;
import jp.co.cybec.cb3.container.service.CB3Service;
import jp.co.cybec.cb3.exception.ServiceException;
import jp.co.cybec.cb3.session.RuntimeParameters;
import jp.co.cybec.cb3.session.ServiceParameters;
import jp.co.cybec.cb3.util.ExitCodeConstant;

/**
 * DataBaseɐڑAselect𔭍s邾̃TvNXB<br>
 * DBւ̃ANZX̓ANZbT(DBAccessorۃNX)gpA<br>
 * ANZbT̎擾getDataAccessContext().lookup("f[^x[XANZXpݒt@C");<br>
 * ɂčsB<br>
 * DBւSQLśAݒt@Cɒ`gpSQLidw肷B
 *
 * @author Teruhisa Abe
 */
public class DBAccess extends CB3Service {

	/**
	 * ANZbT擾Aselect𔭍sB
	 */
	@Override
	protected int doService(ServiceParameters arg0, RuntimeParameters arg1)
			throws ServiceException {
		//ANZbT擾
		DBAccessor ac = (DBAccessor)getDataAccessContext().lookup("dbaccessConfig");

		//dbaccessConfigɐݒ肵SQL𔭍sAR[hl擾o
		showRecord(ac.select("select1"));
		return ExitCodeConstant.SUCCESS;
	}

	/**
	 * 擾lR}hCɏo͂B
	 * @param reader
	 */
	private void showRecord(DBRecordReader reader){

		DBRecord record = null;
		while((record = reader.nextRecord()) != null){
			System.out.println(record.getString("id")+"@@"+record.getString("name"));
		}
	}
}
