/*
 * DMLSample.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.sample.database.dmlsample;

import jp.co.cybec.cb3.accessor.dbaccess.DBAccessor;
import jp.co.cybec.cb3.accessor.dbaccess.DBQueryParameterMap;
import jp.co.cybec.cb3.accessor.dbaccess.DBRecord;
import jp.co.cybec.cb3.accessor.dbaccess.DBRecordReader;
import jp.co.cybec.cb3.container.service.CB3Service;
import jp.co.cybec.cb3.exception.ServiceException;
import jp.co.cybec.cb3.session.RuntimeParameters;
import jp.co.cybec.cb3.session.ServiceParameters;
import jp.co.cybec.cb3.util.ExitCodeConstant;

/**
 * p[^gpSQL𔭍sA
 * ̌ʂR}hCɏo͂TvNXB<br>
 * p[^,p[^wpMAP𐶐AɒlZbgĎgpB
 *
 * @author Teruhisa Abe
 */
public class DMLSample extends CB3Service {

	/**
	 *p[^gpADML𔭍sB
	 */
	@Override
	protected int doService(ServiceParameters serviceparameters,
			RuntimeParameters runtimeparameters) throws ServiceException {

		System.out.println(System.getProperty("line.separator")+"DMLTvs");
		DBAccessor ac = (DBAccessor)getDataAccessContext().lookup("dbaccessConfig");

		//svs폜
		ac.delete("delete");

		//DBԂmF
		showRecord(ac.select("select1"),"selects\n");

		//insertsBp[^gpB
		DBQueryParameterMap insertParam = new DBQueryParameterMap();
		insertParam.put("ID", "1");
		insertParam.put("VALUE","insertTest");
		ac.insert("insert1",insertParam);
		showRecord(ac.select("select1"),"inserts");

		//updatesBp[^gpB
		DBQueryParameterMap updateParam = new DBQueryParameterMap();
		updateParam.put("ID", "1");
		updateParam.put("VALUE","updateTest");
		ac.update("update1",updateParam);
		showRecord(ac.select("select1"),"updates");

		//deletes
		ac.delete("delete");
		showRecord(ac.select("select1"),"deletes");
		return ExitCodeConstant.SUCCESS;
	}

	/**
	 * 擾lR}hCɏo͂B
	 * @param reader DB擾l
	 * @param message R}hCɏo͂郁bZ[W
	 */
	private void showRecord(DBRecordReader reader,String message){

		System.out.println(message);
		DBRecord record = null;
		while((record = reader.nextRecord()) != null){
			System.out.println(record.getString("id")+"@@"+record.getString("value") + "\n");
		}
	}
}


