/*
 * ExceptionHandling.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.sample.exceptionhandling;

import org.springframework.dao.DataAccessException;

import jp.co.cybec.cb3.accessor.dbaccess.DBAccessor;
import jp.co.cybec.cb3.accessor.dbaccess.DBQueryParameterMap;
import jp.co.cybec.cb3.container.service.CB3Service;
import jp.co.cybec.cb3.exception.ServiceException;
import jp.co.cybec.cb3.session.RuntimeParameters;
import jp.co.cybec.cb3.session.ServiceParameters;
import jp.co.cybec.cb3.util.ExitCodeConstant;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;

/**
 * OLb`ApӂbZ[Wo͂TvNX
 * @author Teruhisa Abe
 */
public class ExceptionHandling extends CB3Service {

	/**
	 * DBANZXňӐ}IɗO𔭐B
	 */
	@Override
	protected int doService(ServiceParameters serviceparameters,
			RuntimeParameters runtimeparameters) throws ServiceException {

		LogMessageFactory message = new LogMessageFactory(ExceptionMessageContant.CB3_EXCEPTION_FILE);

		DBQueryParameterMap param = new DBQueryParameterMap();
		DBAccessor ac = (DBAccessor)getDataAccessContext().lookup("dbaccessConfig");

		try {
			ac.delete("delete");

			param.put("ID", "1");
			param.put("VALUE", "test");
			ac.insert("insert", param);

			//IDd邽߃G[
			param.put("ID", "1");
			param.put("VALUE", "error");
			ac.insert("insert", param);

		} catch (DataAccessException e) {
			String exceptionMsg = message.getMessage(ExceptionMessageContant.CB3_EXCEPTION_MESSAGE);
			System.out.println(exceptionMsg);

			//Lb`Obvo
			throw new ServiceException(exceptionMsg, e);
		}

		return ExitCodeConstant.SUCCESS;
	}
}
