/*
 * XMLAccess.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.sample.xml.xmlaccess;

import jp.co.cybec.cb3.accessor.fileaccess.xml.XMLAttribute;
import jp.co.cybec.cb3.accessor.fileaccess.xml.XMLElement;
import jp.co.cybec.cb3.accessor.fileaccess.xml.XMLFileReader;
import jp.co.cybec.cb3.accessor.fileaccess.xml.XMLFileWriter;
import jp.co.cybec.cb3.accessor.fileaccess.xml.XMLPath;
import jp.co.cybec.cb3.container.service.CB3Service;
import jp.co.cybec.cb3.exception.ServiceException;
import jp.co.cybec.cb3.session.RuntimeParameters;
import jp.co.cybec.cb3.session.ServiceParameters;

/**
 * XMLt@CANZX̃TvNX
 *
 * @author Teruhisa Abe
 */
public class XMLAccess extends CB3Service {

	/**
	 * XMLt@Cւ݂̏Ɠǂݍ݂sB
	 */
	@Override
	protected int doService(ServiceParameters serviceparameters,
			RuntimeParameters runtimeparameters) throws ServiceException {
		fileWrite();
		fileRead();
		return 0;
	}

	/**
	 * XMLt@Cւ݂̏s
	 */
	private void fileWrite(){

		//XMLopANZbT擾
		XMLFileWriter writer = (XMLFileWriter)getDataAccessContext().lookup("writerConfig");
		writer.open();

		//ovf𐶐
		XMLElement topElement = new XMLElement("conversation");
		XMLElement greetingElement = new XMLElement("greeting");
		XMLElement jpElement = new XMLElement("thanks");
		XMLElement usElement = new XMLElement("thanks");

		//Zbg
		jpElement.putAttribute(new XMLAttribute("language","japanese"));
		usElement.putAttribute(new XMLAttribute("language","english"));

		//vfZbg
		jpElement.setString("肪Ƃ");
		usElement.setString("thank you.");

		//o
		writer.startElement(topElement);
		writer.startElement(greetingElement);

		writer.dataElement(jpElement);
		writer.dataElement(usElement);

		writer.endElement(greetingElement);
		writer.endElement(topElement);

		writer.close();
	}

	/**
	 * t@C̓ǂݍ݂s
	 */
	private void fileRead(){

		// XMLǂݍݗpANZbT擾
		XMLFileReader reader = (XMLFileReader) getDataAccessContext().lookup("readerConfig");
		reader.open();

		// conversationvf
		XMLPath topPath = reader.selectPath("conversation");

		// conversationvf擾
		XMLElement topElement = topPath.next();
		System.out.println("vf=[" + topElement.getName() + "]");

		// thanksvf
		XMLPath thanksPath = topPath.selectChildPath("greeting/thanks");

		// thanksvf擾
		XMLElement thanksElement;
		while ((thanksElement = thanksPath.next()) != null) {
			// 擾
			XMLAttribute attr = thanksElement.getAttributes().getAttribute("language");
			System.out.println("vf=[" + thanksElement.getName() + "], =[" + attr.getName()
					+ "], l=[" + attr.getString() + "], vf=[" + thanksElement.getString()
					+ "]");
		}

		reader.close();
	}
}
