/* Copyright (C) 2003 TSUTSUMI Kikuo.
   This file is part of the CCUnit Library.

   The CCUnit Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   The CCUnit Library is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the CCUnit Library; see the file COPYING.LESSER.
   If not, write to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.  
*/

/*
 * $Id: CCUnitTest.c,v 1.5 2003/09/28 13:50:36 tsutsumi Exp $
 */

/** @file
 * Test interface module implementation.
 */
#include <ccunit/CCUnitTest.h>

/**
 * @addtogroup CCUnitTest
 * @{
 */

CCUnitTest* ccunit_initTest (CCUnitTest* test,
			     CCUnitTestType_t type,
			     void (*run)(CCUnitTest*, struct CCUnitTestResult*),
			     void (*dtor)(CCUnitTest*))
{
  test->type = type;
  test->run = run;
  test->dtor = dtor;
  return test;
}

void ccunit_deleteTest (CCUnitTest* dt)
{
  if (!dt)
    return;
  if (dt->dtor)
    dt->dtor (dt);
  free (dt);
}

/** @} */
