/* -*- C -*- */
/* Copyright (C) 2003, 2010 TSUTSUMI Kikuo.
   This file is part of the CCUnit Library.

   The CCUnit Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   The CCUnit Library is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the CCUnit Library; see the file COPYING.LESSER.
   If not, write to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.  
*/

/*
 * $Id: CCUnitTestFailure.h,v 1.6 2010/08/20 07:45:17 tsutsumi Exp $
 */
/** @file
 * TestFailure module.
 */

#ifndef CCUNITTESTFAILURE_H
#define CCUNITTESTFAILURE_H

#include <ccunit/CCUnitConfig.h>
#include <ccunit/CCUnitTestFunc.h>

/**
 * @ingroup ModuleHierarchy
 * @defgroup CCUnitTestFailure TestFailure
 *
 * Collects a failed test together with the failed assertion.
 *
 * @{
 */

/**
 * Collects a failed test together with the failed assertion.
 * @see TestResult
 * @ingroup BrowsingCollectedTestResult
 */
typedef struct CCUnitTestFailure
{
  const char* file;				/**< file name */
  unsigned int line;				/**< line No. */
  const char* condstr;				/**< test condition */
  const char* expect;				/**< expect value as string */
  const char* actual;				/**< actual value as string */
  const CCUnitTestFunc* testFunc;		/**< test function object */
} CCUnitTestFailure;

/**
 * Create new test failure.
 *
 * @param file file name cause failure.
 * @param line line number cause failure.
 * @param condstr test condition as string.
 * @param expect expect value as string.
 * @param actual actual value as string.
 * @return new failure object.
 * @ingroup BrowsingCollectedTestResult
 */
extern CCUnitTestFailure* ccunit_newTestFailure (const char* file,
						 unsigned int line,
						 const char* condstr,
						 const char* expect,
						 const char* actual);

/**
 * Delete test failure object.
 *
 * @param failure failure object.
 * @ingroup BrowsingCollectedTestResult
 */
extern void ccunit_deleteTestFailure (CCUnitTestFailure* failure);

/** @} */

#endif
