/* Copyright (C) 2010 TSUTSUMI Kikuo.
   This file is part of the CCUnit Library.

   The CCUnit Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   The CCUnit Library is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the CCUnit Library; see the file COPYING.LESSER.
   If not, see <http://www.gnu.org/licenses/>
*/

/*
 * $Id: testSetup.c,v 1.1 2010/08/19 09:54:00 tsutsumi Exp $
 */
#include <stdio.h>
#include <ccunit/CCUnitAssert.h>

/** test case: test setup */

static int setUpCount;
static int tearDownCount;

void setup_setUp_testSetup ()
{
  setUpCount = 0;
  tearDownCount = 0;
}

void setup_tearDown_testSetup ()
{
  CCUNIT_ASSERT_EQ_INT(setUpCount, 3);
  CCUNIT_ASSERT_EQ_INT(tearDownCount, 3);
}

void setUp_testSetup ()
{
  setUpCount ++;
}

void tearDown_testSetup ()
{
  tearDownCount ++;
}

void test_testSetup1 ()
{
  CCUNIT_ASSERT_EQ_INT(setUpCount, 1);
  CCUNIT_ASSERT_EQ_INT(tearDownCount, 0);
}

void test_testSetup2 ()
{
  CCUNIT_ASSERT_EQ_INT(setUpCount, 2);
  CCUNIT_ASSERT_EQ_INT(tearDownCount, 1);
}

void test_testSetup3 ()
{
  CCUNIT_ASSERT_EQ_INT(setUpCount, 3);
  CCUNIT_ASSERT_EQ_INT(tearDownCount, 2);
}

/** end test case */
