##			   -*- Autoconf -*-
dnl    Copyright (C) 2003, 2010 TSUTSUMI Kikuo.
dnl    This file is part of the CCUnit Library.

dnl    The CCUnit Library is free software; you can redistribute it and/or
dnl    modify it under the terms of the GNU Lesser General Public License
dnl    as published by the Free Software Foundation; either version 2.1 of
dnl    the License, or (at your option) any later version.

dnl    The CCUnit Library is distributed in the hope that it will be
dnl    useful, but WITHOUT ANY WARRANTY; without even the implied warranty
dnl    of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl    GNU Lesser General Public License for more details.

dnl    You should have received a copy of the GNU Lesser General Public
dnl    License along with the CCUnit Library; see the file COPYING.LESSER.
dnl    If not, write to the Free Software Foundation, Inc., 59 Temple
dnl    Place - Suite 330, Boston, MA 02111-1307, USA.  

dnl $Id$

AC_DEFUN([ARG_WITH_DOXYGEN],
[AC_PREREQ(2.50)dnl
AC_ARG_WITH(doxygen,
AC_HELP_STRING([--enable-doxygen],
		[enable documentation generation with doxygen (yes)]),
[if test "x$withval" = xyes; then
  with_doxygen=doxygen
else
  with_doxygen="${withval-doxygen}"
fi], [with_doxygen=doxygen])
AC_ARG_WITH(dot,
AC_HELP_STRING([--enable-dot],[use 'dot' to generate graphs in doxygen (yes)]),
[if test "x$withval" = xyes; then
  with_dot=dot
else
  with_dot="${withval-dot}"
fi],[with_dot=dot])
AC_ARG_ENABLE(html-docs,
AC_HELP_STRING([--enable-html-docs],[enable HTML generation with doxygen (yes)]),
    [], [ enable_html_docs=yes])
AC_ARG_ENABLE(latex-docs,
AC_HELP_STRING([--enable-latex-docs],
    [enable LaTeX documentation generation with doxygen (no)]),
    [], [ enable_latex_docs=no])

if test "x$with_doxygen" = xno; then
  enable_doc=no
else
  AC_PATH_PROG(DOXYGEN, $with_doxygen, , $PATH)
  if test x$DOXYGEN = x; then
    AC_MSG_WARN([could not find doxygen])
    enable_doc=no
  else
    enable_doc=yes
  fi
fi

AM_CONDITIONAL(DOC, test x$enable_doc = xyes)

if test "x$with_dot" = xno; then
  enable_dot=no
else
  AC_PATH_PROG(DOT, $with_dot,,$PATH)
  if test x$DOT = x; then
    AC_MSG_WARN([could not find dot])
    enable_dot=no
  else
    enable_dot=yes
    DOT_PATH=`dirname $DOT`
  fi
fi

AC_SUBST(DOT_PATH)
AC_SUBST(enable_dot)
AC_SUBST(enable_html_docs)
AC_SUBST(enable_latex_docs)
])
