/* Copyright (C) 2010 TSUTSUMI Kikuo.
   This file is part of the CCUnit Library.

   The CCUnit Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   The CCUnit Library is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the CCUnit Library; see the file COPYING.LESSER.
   If not, see <http://www.gnu.org/licenses/>
*/

/*
 * $Id$
 */

#include <ccunit/CCUnitTestCase.h>
#include <ccunit/CCUnitTestSuite.h>
#include <ccunit/CCUnitTestRunner.h>

extern void test_complex_new ();
extern void test_complex_equals ();

int main ()
{
  CCUnitTestCase* testCase;
  CCUnitTestSuite* suite;
  CCUnitTestRunner* runner;
  int ret;
  testCase = ccunit_newTestCase ("complex test");
  ccunit_addNewTestFunc (testCase,
                         "test_complex_new",
                         "complex new test",
                         test_complex_new);
  ccunit_addNewTestFunc (testCase, 
                         "test_complex_equals",
                         "complex equals test",
                         test_complex_equals);
  suite = ccunit_newTestSuite ("complex test suite");
  ccunit_addTestCase (suite, testCase);
  runner = ccunit_newTestRunner (stdout);
  ret = ccunit_runTestRunner (runner, suite);
  ccunit_deleteTestRunner (runner);
  ccunit_deleteTestSuite (suite);
  /* ccunit_deleteTestCase (testCase); // testCase was deleted when suite was deleted */
  return ret;
}
