/* Copyright (C) 2003, 2010 TSUTSUMI Kikuo.
   This file is part of the CCUnit Library.

   The CCUnit Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   The CCUnit Library is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the CCUnit Library; see the file COPYING.LESSER.
   If not, write to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.  
*/

/*
 * $Id$
 */

#include <ccunit/CCUnitTestSuite.h>
#include <ccunit/CCUnitTestRunner.h>

/* test case testComplex.c */
extern void setUp_test_complex ();
extern void tearDown_test_complex ();
extern void test_complex_new ();
extern void test_complex_equals ();
extern void test_complex_to_string ();

/* test case testComplexArith.c */
extern void setUp_test_complex_arith ();
extern void tearDown_test_complex_arith ();
extern void test_complex_add ();
extern void test_complex_sub ();
extern void test_complex_mul ();
extern void test_complex_div ();

int main ()
{
  CCUnitTestCase* testCase, * testArith;
  CCUnitTestSuite* suite;
  CCUnitTestRunner* runner;
  int ret;
  /* test complex */
  testCase = ccunit_newTestCase ("test complex");
  ccunit_addNewTestFunc (testCase,
                         "setUp_test_complex",
                         "setUp_test_complex",
                         setUp_test_complex);
  ccunit_addNewTestFunc (testCase, 
                         "tearDown_test_complex",
                         "tearDown_test_complex",
                         tearDown_test_complex);
  ccunit_addNewTestFunc (testCase,
                         "test_complex_new",
                         "test new",
                         test_complex_new);
  ccunit_addNewTestFunc (testCase, 
                         "test_complex_equals",
                         "complex equals test",
                         test_complex_equals);
  /* test complex arith */
  testArith = ccunit_newTestCase ("test complex arith");
  ccunit_addNewTestFunc (testArith,
                         "setUp_test_complex_arith",
                         "setUp_test_complex_arith",
                         setUp_test_complex_arith);
  ccunit_addNewTestFunc (testArith, 
                         "tearDown_test_complex_arith",
                         "tearDown_test_complex_arith",
                         tearDown_test_complex_arith);
  ccunit_addNewTestFunc (testArith,
                         "test_complex_add",
                         "test add",
                         test_complex_add);
  ccunit_addNewTestFunc (testArith, 
                         "test_complex_sub",
                         "test sub",
                         test_complex_sub);
  ccunit_addNewTestFunc (testArith,
                         "test_complex_mul",
                         "test mul",
                         test_complex_mul);
  ccunit_addNewTestFunc (testArith, 
                         "test_complex_div",
                         "test div",
                         test_complex_div);
  suite = ccunit_newTestSuite ("complex test suite");
  ccunit_addTestCase (suite, testCase);
  ccunit_addTestCase (suite, testArith);
  runner = ccunit_newTestRunner (stdout);
  ret = ccunit_runTestRunner (runner, suite);
  ccunit_deleteTestRunner (runner);
  ccunit_deleteTestSuite (suite);
  return ret;
}
