/* Copyright (C) 2003, 2010 TSUTSUMI Kikuo.
   This file is part of the CCUnit Library.

   The CCUnit Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   The CCUnit Library is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the CCUnit Library; see the file COPYING.LESSER.
   If not, write to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.  
*/

/*
 * $Id$
 */

#include <ccunit/CCUnitAssert.h>

#include "complex.h"

/** TEST CASE: complex number add test */

static complex_t* c10_1;

void setUp_test_complex ()
{
  c10_1 = complex_new (10, 1);
}

void tearDown_test_complex ()
{
  complex_delete (c10_1);
}

/** test new */
void test_complex_new ()
{
  CCUNIT_ASSERT_EQ_DOUBLE (10, c10_1->real);
  CCUNIT_ASSERT_EQ_DOUBLE (1, c10_1->imaginary);
}

/** test equals */
void test_complex_equals ()
{
  complex_t* c10_1_2 = complex_new (10, 1);
  complex_t* c1_1 = complex_new (1, 1);
  CCUNIT_ASSERT_TEST_OBJ (c10_1, complex_equals, c10_1_2, complex_to_string);
  CCUNIT_ASSERT_TEST_OBJ (c10_1, !complex_equals, c1_1, complex_to_string);
  complex_delete (c10_1_2);
  complex_delete (c1_1);
}

/** test to_string */
void test_complex_to_string ()
{
  complex_t* c10_1 = complex_new (10, 1);
  char* s10_1 = complex_to_string (c10_1);
  CCUNIT_ASSERT_EQ_STR ("10+1i", s10_1);
  complex_delete (c10_1);
  free (s10_1);
}

/** end test case */
