/* Copyright (C) 2003, 2010 TSUTSUMI Kikuo.
   This file is part of the CCUnit Library.

   The CCUnit Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   The CCUnit Library is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the CCUnit Library; see the file COPYING.LESSER.
   If not, write to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.  
*/

/*
 * $Id$
 */
/**@file
 * TestFailure module implementation.
 */

#include <stdio.h>
#include <ccunit/CCUnitTestFailure.h>

/** @addtogroup CCUnitTestFailure TestFailure
 * @{
 */

CCUnitTestFailure* ccunit_newTestFailure (const char* file,
					  unsigned int line,
					  const char* condstr,
					  const char* expect,
					  const char* actual)
{
  CCUnitTestFailure* f = calloc (1, sizeof (*f));
  f->file = file;
  f->line = line;
  f->condstr = condstr;
  f->expect = safe_strdup (expect);
  f->actual = safe_strdup (actual);
  return f;
}

void ccunit_deleteTestFailure (CCUnitTestFailure* failure)
{
  safe_free (failure->expect);
  safe_free (failure->actual);
  safe_free (failure);
}

/** @} */
