/* Copyright (C) 2003, 2010 TSUTSUMI Kikuo.
   This file is part of the CCUnit Library.

   The CCUnit Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   The CCUnit Library is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the CCUnit Library; see the file COPYING.LESSER.
   If not, write to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.  
*/

/*
 * $Id$
 */

#include <ccunit/CCUnitTestCase.h>
#include <ccunit/CCUnitTestResult.h>

extern void test_complex_new ();
extern void test_complex_equals ();

int main ()
{
  CCUnitTestCase* testCase;
  CCUnitTestResult* result;
  bool success;
  testCase = ccunit_newTestCase ("complex test");
  ccunit_addNewTestFunc (testCase,
                         "test_complex_new",
                         "complex new test",
                         test_complex_new);
  ccunit_addNewTestFunc (testCase, 
                         "test_complex_equals",
                         "complex equals test",
                         test_complex_equals);
  result = ccunit_runTestCase (testCase);
  success = ccunit_wasSuccessful (result);
  ccunit_deleteTestCase (testCase);
  ccunit_deleteTestResult (result);
  return success ? 0 : -1;
}
