/* Copyright (C) 2003 TSUTSUMI Kikuo.
   This file is part of the CCUnit Library.

   The CCUnit Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   The CCUnit Library is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the CCUnit Library; see the file COPYING.LESSER.
   If not, write to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.  
*/

/*
 * $Id$
 */

/** @file
 * generate a source code to creating test suite.
 */

#include <ccunit/CCUnit.h>

/** @ingroup CCUnitMakeSuite
 * @defgroup CreatingTestSuiteTool Creating test suite tool ccunit_makeSuite
 *
 * Generate a source code to creating test suite.
 *
 * @see ccunit_makeSuite
 * @{
 */

/**
 * To generate a test suite making source code.
 *
 * @see ccunit_makeSuite
 * @ingroup CreatingTestSuite
 */
int main (int ac, char** av)
{
  int rc;
#if CCUNIT_WITH_DMALLOC
  dmalloc_debug_setup ("log-stats,"
		       "log-non-free,"
		       "log-bad-space,"
		       "log-elapsed-time,"
		       "check-fence,"
		       "free-blank,"
		       "error-abort,"
		       "alloc-blank,"
		       "catch-null,"
		       "inter=100,"
		       "log=dm-makeSuite.log");
#endif
  rc = ccunit_makeSuite (ac, av);
#if CCUNIT_WITH_DMALLOC && !CCUNIT_HAVE_ATEXIT && !CCUNIT_HAVE_ONEXIT
  dmalloc_shutdown ();
#endif
  return rc;
}

/** @} */
