/* Copyright (C) 2003 TSUTSUMI Kikuo.
   This file is part of the CCUnit Library.

   The CCUnit Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   The CCUnit Library is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the CCUnit Library; see the file COPYING.LESSER.
   If not, write to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.  
*/

/*
 * $Id: CCUnitTestCase.c,v 1.8 2003/10/05 11:29:59 tsutsumi Exp $
 */
/**@file
 * TestCase module implementation.
 */

#include <ccunit/CCUnitTestCase.h>

/**
 * @addtogroup CCUnitTestCase
 * @{
 */

CCUnitTestCase* ccunit_newTestCase (const char* name,
				    const char* desc,
				    void (*runTest)())
{
  CCUnitTestCase* testCase = calloc (1, sizeof (*testCase));
  if (!testCase)
    return NULL;
  testCase->name = safe_strdup (name);
  testCase->desc = !desc ? safe_strdup (name) : strdup (desc);
  testCase->runTest = runTest;
  return testCase;
}

inline CCUnitTestFunc* ccunit_newTestFunc (const char* name,
					   const char* desc,
					   void (*func)())
{
  return (CCUnitTestFunc*) ccunit_newTestCase (name, desc, func);
}

void ccunit_deleteTestCase (CCUnitTestCase* testCase)
{
  if (!testCase)
    return;
  safe_free ((char*)testCase->name);
  safe_free ((char*)testCase->desc);
  free (testCase);
}

inline void ccunit_deleteTestFunc (CCUnitTestFunc* testFunc)
{
  ccunit_deleteTestCase ((CCUnitTestCase*)testFunc);
}

/** @} */
