/* -*- mode: C; -*- */
/* Copyright (C) 2003 TSUTSUMI Kikuo.
   This file is part of the CCUnit Library.

   The CCUnit Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   The CCUnit Library is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the CCUnit Library; see the file COPYING.LESSER.
   If not, write to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.  
*/

/*
 * $Id: CCUnitTest.h,v 1.7 2003/09/28 13:50:21 tsutsumi Exp $
 */

/**
 * @file
 * Test interface module.
 */

#ifndef CCUNITTEST_H
#define CCUNITTEST_H

#include <ccunit/CCUnitConfig.h>

/**
 * @ingroup ModuleHierarchy
 * @defgroup CCUnitTest Test
 * Test interface module.
 * @{
 */

/**
 * Test class type.
 * @ingroup BrowsingCollectedTestResult
 */
typedef enum CCUnitTestType_t {
  ccunitTypeTest,				/**< Test class */
  ccunitTypeSuite,				/**< TestSuite class */
  ccunitTypeFixture,				/**< TestFixture class */
  ccunitTypeCase,				/**< TestCase class */
  ccunitTypeLast_				/**< last tag */
} CCUnitTestType_t;

struct CCUnitTestResult;

/**
 * Run Test and collect its results.
 *
 * @see CCUnitTestResult
 * @ingroup BrowsingCollectedTestResult
 */
typedef struct CCUnitTest
{
  CCUnitTestType_t type;			/**< test class type */
  void (*run)(struct CCUnitTest*, struct CCUnitTestResult*); /**< test run method */
  void (*dtor)(struct CCUnitTest*);		/**< test object destructor */
} CCUnitTest;

typedef struct CCUnitTestDfn
{
  CCUnitTestType_t type;
} CCUnitTestDfn;

/**
 * Initialize Test class.
 * @param test test object to initialize.
 * @param type test type.
 * @param run run test function.
 * @param dtor destructor.
 * @return initialized test object.
 * @ingroup BrowsingCollectedTestResult
 */
extern CCUnitTest*
ccunit_initTest (CCUnitTest* test,
		 CCUnitTestType_t type,
		 void (*run)(CCUnitTest*, struct CCUnitTestResult*),
		 void (*dtor)(CCUnitTest*));

/**
 * Test class destructor.
 * @param test test object to delete.
 * @ingroup BrowsingCollectedTestResult
 */
extern void ccunit_deleteTest (CCUnitTest* test);

/** @} */

#endif
