/* -*- mode: C; -*- */
/* Copyright (C) 2003 TSUTSUMI Kikuo.
   This file is part of the CCUnit Library.

   The CCUnit Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   The CCUnit Library is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the CCUnit Library; see the file COPYING.LESSER.
   If not, write to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.  
*/

/*
 * $Id: CCUnitTestRunner.h,v 1.7 2003/09/29 15:10:00 tsutsumi Exp $
 */
/**@file
 * TestRunner module.
 */
#ifndef CCUNITTESTRUNNER_H
#define CCUNITTESTRUNNER_H

#include <stdio.h>
#include <ccunit/CCUnitConfig.h>
#include <ccunit/CCUnitTestResult.h>
#include <ccunit/CCUnitTestSuite.h>
#include <ccunit/CCUnitTestListener.h>

/**
 * @ingroup CCUnitTestListener
 * @defgroup CCUnitTestRunner TestRunner
 * Runs a single test and collects its results.  This method can be
 * used to start a test run from your program.
 * @{
 */

/**
 * A command line based tool to run tests.  Runs a single test and
 * collects its results.  This method can be used to start a test run
 * from your program.
 * @code
 *     int main (int ac, char** av)
 *     {
 *       CCUnitTestRunner* runner = ccunit_newTestRunner (NULL);
 *       CCUnitTestSuite* suite = <var>CREATE_TESTSUITE</var> ();
 *       return runner->run (runner, suite);
 *     }
 * @endcode
 *
 * @see CCUnitTestSuite, CCUnitTestCase.
 * @ingroup ExecutingTest
 */
typedef struct CCUnitTestRunner CCUnitTestRunner;

/**
 * Runs a single test and collects its results.  This method can be
 * used to start a test run from your program.
 *
 * @see CCUnitTestSuite, CCUnitTestCase.
 */
struct CCUnitTestRunner
{
  CCUnitTestListener listener;			/**< test listeners */
  CCUnitTestResult* result;			/**< test result container */
  int (*run)(CCUnitTestRunner*, CCUnitTestSuite*); /**< test run function */
  FILE* ofp;					/**< result output stream */
};

/**
 * constructor.
 * @param output prints test result into this stream.
 * @return new CCUnitTestRunner object.
 * @ingroup ExecutingTest
 */
extern CCUnitTestRunner* ccunit_newTestRunner (FILE* output);

/**
 * destructor.
 * @param runner TestRunner object to destruct.
 * @ingroup ExecutingTest
 */
extern void ccunit_deleteTestRunner (CCUnitTestRunner* runner);

/**
 * Runs test suite.
 *
 * @param runner test runner
 * @param suite test suite
 * @return 0 if succeeded, -1 if error occurred.
 * @ingroup ExecutingTest
 */
extern inline int ccunit_runTestRunner (CCUnitTestRunner* runner,
					CCUnitTestSuite* suite);

/**
 * Get test result.
 *
 * @param runner test runner.
 * @return test result object.
 */
extern inline CCUnitTestResult* ccunit_getResult (CCUnitTestRunner* runner);

/** @} */

#endif
