#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include <gsl/gsl_rng.h>
#include <gsl/gsl_randist.h>

#include <cdescent.h>

#include "mmreal_test.h"

/*** sparse to dense, dense to sparse: reallocate version ***/
bool
mm_real_sparse_to_dense_2 (mm_sparse *s)
{
	int		j, k;

	int		m;
	int		n;
	int		nnz;

	double	*tmp_data;

	double	*td;
	int		*si;
	int		*sp;	
	double	*sd;

	if (!mm_real_is_sparse (s)) return false;

	m = s->m;
	n = s->n;
	nnz = m * n;

	/* copy s->data */
	tmp_data = (double *) malloc (s->nnz * sizeof (double));
	for (k = 0; k < s->nnz; k++) tmp_data[k] = s->data[k];
	td = tmp_data;

	/* reallocate s->data */
	free (s->data);
	s->data = (double *) malloc (nnz * sizeof (double));
	for (k = 0; k < nnz; k++) s->data[k] = 0.;

	/* convert sparse to dense */
	si = s->i;
	sp = s->p;
	sd = s->data;
	for (j = 0; j < n; j++) {
		int		np = sp[1] - *sp;
		for (k = 0; k < np; k++) {
			sd[*si] = *td;
			si++;
			td++;
		}
		sd += s->m;
		sp++;
	}
	free (tmp_data);

	mm_set_array (&s->typecode);
	s->nnz = nnz;
	free (s->i);
	s->i = NULL;
	free (s->p);
	s->p = NULL;

	return true;
}

bool
mm_real_dense_to_sparse_2 (mm_dense *d, const double threshold)
{
	int		i, j, k;

	int		m;
	int		n;
	int		nnz;

	int		*di;
	int		*dp;
	double	*dd;
	double	*d0;

	if (!mm_real_is_dense (d)) return false;

	m = d->m;
	n = d->n;
	nnz = d->nnz;

	d0 = d->data;

	/* convert dense to sparse */
	d->i = (int *) malloc (nnz * sizeof (int));
	d->p = (int *) malloc ((n + 1) * sizeof (int));
	di = d->i;
	dp = d->p;
	dd = d->data;

	k = 0;
	*dp = 0;
	for (j = 0; j < n; j++) {
		for (i = 0; i < m; i++) {
			double	val = *d0;
			if (fabs (val) > threshold) {
				*(di++) = i;
				*(dd++) = val;
				k++;
			}
			d0++;
		}
		*(++dp) = k;
	}

	mm_set_coordinate (&d->typecode);
	if (k != d->nnz) mm_real_realloc (d, k);

	return true;
}


