#include <stdio.h>
#include <stdlib.h>
#include <time.h>

static void
swap (int *array, const int i, const int j)
{
	int		tmp = array[j];
	array[j] = array[i];
	array[i] = tmp;
	return;
}

static void
shuffle (const int size, int array[])
{
	int		i;
	for (i = 0; i < size; i++) {
		int		j = i + rand () % (size - i);
		swap (array, i, j);
	}
	return;
}

static int *
random_sequence (const int size)
{
	int		i;
	int		*array = (int *) malloc (size * sizeof (int));
	for (i = 0; i < size; i++) array[i] = i;
	shuffle (size, array);
	return array;
}

static int *
copy (const int n, const int *a)
{
	int	i;
	int	*b = (int *) malloc (n * sizeof (double));
	for (i = 0; i < n; i++) b[i] = a[i];
	return b;
}

static int
compare (const void *a, const void *b)
{
	int	_a = *(int *) a;
	int	_b = *(int *) b;
	return _a - _b;
}

int
main (void)
{
	int		i;
	int		n = 10000;
	int		*a;
	int		*b;

	srand (time (NULL));

	a = random_sequence (n);
	for (i = 0; i < n; i += 100) fprintf (stderr, "a[%d] = %d\n", i, a[i]);

	b = copy (n, a);

	qsort (b, n, sizeof (int), &compare);

	for (i = 0; i < n; i++) {
		if (b[i] != i) {
			fprintf (stderr, "a is invalid.\n");
			break;
		}
	}

	free (a);
	free (b);

	return EXIT_SUCCESS;
}
