unit CellK;

interface

uses CellG, CellV;

type
  TCellK = class
  private
    _cellG: TCellG;
    _cellV: TCellV;
    token: TToken;
    retIS: Boolean;
    loop: Boolean;
    forex: Boolean;
    con: Boolean;
    saIndex: integer;
    saCode: integer;
    sahen: integer;
    breCode: integer;
    shift: integer;
    ident: string;
  public
    constructor Create(v: TCellV; g: TCellG);
    function compile: Boolean;
    procedure _module;
    procedure _block_body;
    procedure _block;
    procedure _function;
    procedure _array;
    procedure _statement;
    procedure _condition;
    procedure _expression;
    procedure _expression1;
    procedure _expression2;
    procedure _term;
    procedure _factor;
    procedure _Sa;
    function hairetu(const ti: integer): Boolean;
    procedure checkKata(t: integer);
    procedure shokika;
  end;

implementation

{ TCellK }

procedure TCellK._block_body;
begin
  while true do
  begin
    case token.kind of
    CellG._aI:
        _array;
    CellG._Rbrace,CellG.dollar:
        break;
    CellG._I,CellG._S, CellG._V:
        break;
    else
        _statement;
    end;
  end;
end;

function TCellK.compile: Boolean;
begin
        _cellG.shokika;
        _cellV.shokika;
        shokika;
        token:=_cellG.makeToken;
  while token.kind <> CellG.dollar do
  begin
        _module;
  end;
        result:=_cellG.e<1;
end;

constructor TCellK.Create(v: TCellV; g: TCellG);
begin
        inherited Create;
        shokika;
        _cellV:=v;
        _cellG:=g;
end;

procedure TCellK._module;
var
  backP: integer;
  backP1, backP2: integer;
begin
  if token.kind = CellG.Id then
  begin
        _cellG.setModule(token.id);
  end else
  begin
        _cellG.error('W[܂');
  end;
        token:=_cellG.checkGet(_cellG.makeToken,CellG._Lbrace);
        backP1:=_cellV.genCodeP(CellV.ict,0);
        backP2:=_cellV.genCodeP(CellV.ics,0);
        _cellG.blockBegin;
        _block_body;
  while (token.kind = CellG._I)or(token.kind = CellG._S)or(token.kind = CellG._V) do
  begin
        backP:=_cellV.genCodeP(CellV.jmp,0);
        _function;
        _cellV.backPatchJ(backP);
        _block_body;
  end;
        _cellV.backPatch(backP1,backP2);
        _cellG.blockEnd;
        token:=_cellG.checkGet(token,CellG._Rbrace);
end;

procedure TCellK._array;
var
  v: integer;
  id: string;
begin
        token:=_cellG.makeToken;
  while true do
  begin
    if token.kind = CellG.Id then
    begin
        id:=token.id;
        token:=_cellG.checkGet(_cellG.makeToken,CellG._Lbracket);
      if token.kind = CellG.Num then
      begin
                v:=token.value;
                token:=_cellG.makeToken;
        if token.kind = CellG._Rbracket then
        begin
                _cellG.tableA1int(id,v);
                token:=_cellG.makeToken;
        end else
                if token.kind = CellG._Ex then
        begin
                token:=_cellG.makeToken;
          if token.kind = CellG.Num then
          begin
                _cellG.tableA2int(id,v,token.value);
                token:=_cellG.checkGet(_cellG.makeToken,CellG._Rbracket);
          end else
          begin
                _cellG.error('܂');
                Exit;
          end;
        end else
        begin
                _cellG.error('O܂');
                Exit;
        end;
      end;
    end;
    if token.kind = CellG._Comma then
    begin
        token:=_cellG.makeToken;
        continue;
    end else
        if token.kind = CellG._Semicolon then
    begin
        token:=_cellG.makeToken;
        Exit;
    end else
    begin
        _cellG.error('; or , ܂');
        Exit;
    end;
  end;
end;

procedure TCellK._block;
var
  backP1, backP2: integer;
begin
        token:=_cellG.checkGet(token,CellG._Lbrace);
        backP1:=_cellV.genCodeP(CellV.ict,0);
        backP2:=_cellV.genCodeP(CellV.ics,0);
        _block_body;
        _cellV.backPatch(backP1,backP2);
        _cellG.blockEnd;
  if token.kind = CellG.dollar then
  begin
        _cellG.error('}܂');
  end else
  begin
        token:=_cellG.makeToken;
  end;
end;

procedure TCellK._function;
var
  f: integer;
  s: string;
  err, x: Boolean;
begin
        s:='';
        f:=token.kind;
        x:=f=CellG._V;
        token:=_cellG.makeToken;
  if token.kind = CellG.Id then
  begin
        s:=token.id;
        token:=_cellG.makeToken;
        _cellG.tableFunc(s,_cellV.nextCode,f);
  end else
  begin
        _cellG.error('֐܂');
  end;
        token:=_cellG.checkGet(token,CellG._Lparen);
        _cellG.blockBegin;
        err:=false;
  if token.kind = CellG._Rparen then
  begin
        token:=_cellG.makeToken;
  end else
  begin
    while true do
    begin

        f:=token.kind;
      if (f = CellG._I)or(f = CellG._S) then
      begin
                token:=_cellG.makeToken;
        if token.kind = CellG.Id then
        begin
          if f = CellG._I then
          begin
                _cellG.tablePint(token.id);
          end else
          begin
                _cellG.tablePstr(token.id);
          end;
                token:=_cellG.makeToken;
        end else
        begin
                _cellG.error('܂');
        end;
        if token.kind = CellG._Comma then
        begin
                token:=_cellG.makeToken;
                continue;
        end else
                if token.kind = CellG._Rparen then
        begin
                _cellG.endPar;
                token:=_cellG.makeToken;
                break;
        end else
        begin
                _cellG.error(',or)܂');
                err:=true;
                break;
        end;
      end else
      begin
                _cellG.error('SorI܂');
                err:=true;
                break;
      end;

    end;
  end;
  if err = true then
  begin
    while (token.kind <> CellG._Lbrace)and(token.kind <> CellG._Rbrace)and(token.kind <> CellG._Semicolon) do
    begin
      if token.kind = CellG._Rbrace then
      begin
                _cellG.error('{ ܂');
                _cellG.blockEnd;
                token:=_cellG.makeToken;
                Exit;
      end;
        token:=_cellG.makeToken;
    end;
  end;
  if (err = false)and(s <> '') then
  begin
        _cellG.checkKari(s);
  end;
        _block;
  if x = true then
  begin
        _cellV.genCodeRV;
        retIS:=true;
  end;
  if retIS = false then
  begin
        _cellG.error('return܂');
  end;
        retIS:=false;
end;

procedure TCellK._expression;
var
  sa, saI, saC: integer;
  s, ti: integer;
begin
        _expression1;
  if token.kind <> CellG._Equal then
  begin
        Exit;
  end;
  if sahen = 0 then
  begin
        _cellG.error('܂B');
  end;
        s:=shift;
        saI:=saIndex;
        saC:=saCode;
  if sahen = -1 then
  begin
    if shift = 2 then
    begin
        ti:=_cellG.tableString(ident);
        sahen:=CellG.strID;
        _cellV.backPatchL(saC,ti,1);
        s:=2;
    end else
    begin
        ti:=_cellG.tableInt(ident);
        sahen:=CellG.intID;
        _cellV.backPatchL(saC,ti,0);
        s:=1;
    end;
  end;
        shift:=0;
        sa:=sahen;
        token:=_cellG.makeToken;
        _expression;
  if (sa <> -1)and(s <> shift) then
  begin
    if ((sa = CellG.intID)or(sa = CellG.strID))and(sa <> CellG.arrI)and(sa <> CellG.arrS) then
    begin
      if shift = 2 then
      begin
                _cellG.changeT(saI,strID,false);
                _cellV.backPatchL(saC,saI,1);
      end else
      begin
                _cellG.changeT(saI,intID,false);
                _cellV.backPatchL(saC,saI,0);
      end;
    end else
    begin
        _cellG.error('^v܂');
    end;
  end;
  if s <> shift then
  begin
    if (s = 1)and(con = true) then
    begin
        shift:=1;
    end;
  end;
        sa:=sahen;
  if (token.kind = CellG._Rparen)or(token.kind = CellG._Semicolon) then
  begin
    if (shift = 2)or((shift = 0)and(s = 2)) then
    begin
        ti:=_cellV.genCodeO(CellV.sls);
    end else
    begin
        ti:=_cellV.genCodeO(CellV.sld);
    end;
        ident:='';
        sa:=0;
  end else
  begin
    if (shift = 2)or((shift = 0)and(s = 2)) then
    begin
        ti:=_cellV.genCodeO(CellV.sds);
    end else
    begin
        ti:=_cellV.genCodeO(CellV.sid);
    end;
  end;
  if sahen = 0 then
  begin
        _cellG.setScI(ti);
  end;
        sahen:=sa;
        saIndex:=0;
        saCode:=0;
        con:=false;
end;

procedure TCellK._statement;
var
  tk, tIndex, backP1, backP2, backP3, backP4, breTaihi: integer;
  i: integer;
begin
  while true do
  begin
    case token.kind of
    CellG._Lbrace:
    begin
        _cellG.blockBegin;
        _cellV.genCodeP(CellV.dit,_cellG.bLevel);
        _block;
        _cellV.genCodeP(CellV.dik,_cellG.bLevel+1);
        break;
    end;
    CellG.Id:
    begin
        _expression;
        token:=_cellG.checkGet(token,CellG._Semicolon);
        shift:=0;
        break;
    end;
    CellG._Read,CellG._ReadS:
    begin
        i:=token.kind;
        token:=_cellG.makeToken;
      if token.kind <> CellG.Id then
      begin
                _cellG.error('O܂');
                token:=_cellG.makeToken;
                continue;
      end;
        tIndex:=_cellG.searchT(token.id);
        tk:=_cellG.tKind(tIndex);
      if (tk = CellG.strID)or(tk = CellG.parS)or((tk = 0)and(i = CellG._ReadS)) then
      begin
        if tk = 0 then
        begin
                tIndex:=_cellG.tableString(token.id);
        end;
                _cellV.genCodeT(CellV.las,tIndex);
                token:=_cellG.makeToken;
                _cellV.genCodeO(CellV.ins);
                _cellV.genCodeO(CellV.sds);
      end else
                if (tk = CellG.arrI)or(tk = CellG.parI)or(tk = CellG.intID)or
                  (tk = intID)or((tk = 0)and(i = CellG._Read)) then
      begin
        if tk = 0 then
        begin
                tIndex:=_cellG.tableInt(token.id);
        end;
                _cellV.genCodeT(CellV.lda,tIndex);
        if tk = CellG.arrI then
        begin
          if hairetu(tIndex) = false then
          begin
                continue;
          end;
        end else
        begin
                token:=_cellG.makeToken;
        end;
                _cellV.genCodeO(CellV.ini);
                _cellV.genCodeO(CellV.sid);
      end else
      begin
                _cellG.error('錾Ă܂');
                token:=_cellG.makeToken;
                continue;
      end;
        token:=_cellG.checkGet(token,CellG._Semicolon);
        break;
    end;
    CellG._Print,CellG._Println:
    begin
        tk:=token.kind;
      repeat
                token:=_cellG.makeToken;
        if (token.kind = CellG._Semicolon)or(token.kind = CellG._Rbrace) then
        begin
                break;
        end;
                _expression;
        if shift = 2 then
        begin
                _cellV.genCodeO(CellV.prs);
        end else
        begin
                _cellV.genCodeO(CellV.prt);
        end;
                shift:=0;
      until token.kind <> CellG._Comma;
      if tk = CellG._Println then
      begin
                _cellV.genCodeO(CellV.prl);
      end;
                token:=_cellG.checkGet(token,CellG._Semicolon);
                break;
    end;
    CellG._If:
    begin
        token:=_cellG.checkGet(_cellG.makeToken,CellG._Lparen);
        _expression;
      if con = false then
      begin
                _cellG.error('KvłB');
      end;
        con:=false;
        shift:=0;
        token:=_cellG.checkGet(token,CellG._Rparen);
        backP1:=_cellV.genCodeP(CellV.jpc,0);
        _statement;
      if token.kind = CellG._Else then
      begin
                backP2:=_cellV.genCodeP(CellV.jmp,0);
                _cellV.backPatchJ(backP1);
                token:=_cellG.makeToken;
                _statement;
                _cellV.backPatchJ(backP2);
      end else
      begin
                _cellV.backPatchJ(backP1);
      end;
        break;
    end;
    CellG._For:
    begin
        token:=_cellG.checkGet(_cellG.makeToken,CellG._Lparen);
        shift:=1;
        _expression;
        token:=_cellG.checkGet(token,CellG._Semicolon);
        backP2:=_cellV.nextCode;
        _expression;
      if con = false then
      begin
                _cellG.error('Kvł');
      end;
        con:=false;
        token:=_cellG.checkGet(token,CellG._Semicolon);
        backP1:=_cellV.genCodeP(CellV.jpc,0);
        backP3:=_cellV.genCodeP(CellV.jmp,0);
        backP4:=_cellV.nextCode;
        forex:=true;
        _expression;
        forex:=false;
        shift:=0;
        _cellV.genCodeP(CellV.jmp,backP2);
        token:=_cellG.checkGet(token,CellG._Rparen);
        _cellV.backPatchJ(backP3);
        loop:=true;
        breTaihi:=breCode;
        breCode:=0;
        _statement;
        _cellV.genCodeP(CellV.jmp,backP4);
        _cellV.backPatchJ(backP1);
        _cellV.backBreak(breCode);
        loop:=false;
        breCode:=breTaihi;
        break;
    end;
    CellG._While:
    begin
        token:=_cellG.checkGet(_cellG.makeToken,CellG._Lparen);
        backP2:=_cellV.nextCode;
        _expression;
      if con = false then
      begin
                _cellG.error('Kvł');
      end;
        con:=false;
        shift:=0;
        token:=_cellG.checkGet(token,CellG._Rparen);
        backP1:=_cellV.genCodeP(CellV.jpc,0);
        loop:=true;
        breTaihi:=breCode;
        breCode:=0;
        _statement;
        _cellV.genCodeP(CellV.jmp,backP2);
        _cellV.backPatchJ(backP1);
        _cellV.backBreak(breCode);
        loop:=false;
        breCode:=breTaihi;
        break;
    end;
    CellG._Do:
    begin
        backP1:=_cellV.nextCode;
        token:=_cellG.makeToken;
        loop:=true;
        breTaihi:=breCode;
        _statement;
      if token.kind <> CellG._While then
      begin
                _cellG.error('while܂');
                continue;
      end else
      begin
                token:=_cellG.makeToken;
      end;
        token:=_cellG.checkGet(token,CellG._Lparen);
        _expression;
      if con = false then
      begin
                _cellG.error('Kvł');
      end;
        con:=false;
        shift:=0;
        token:=_cellG.checkGet(token,CellG._Rparen);
        backP2:=_cellV.genCodeP(CellV.jpc,0);
        _cellV.genCodeP(CellV.jmp,backP1);
        _cellV.backPatchJ(backP2);
        _cellV.backBreak(breCode);
        loop:=false;
        breCode:=breTaihi;
        token:=_cellG.checkGet(token,CellG._Semicolon);
        break;
    end;
    CellG._Return:
    begin
        token:=_cellG.makeToken;
        tk:=_cellG.funcModori;
      if tk <> CellG._V then
      begin
        if (token.kind = CellG._Semicolon)or(token.kind = CellG._Rbrace) then
        begin
                _cellG.error('߂l܂');
                continue;
        end;
        if tk = CellG._S then
        begin
                shift:=2;
        end else
        begin
                shift:=1;
        end;
                _expression;
                shift:=0;
      end;
        retIS:=true;
        _cellV.genCodeR;
        token:=_cellG.checkGet(token,CellG._Semicolon);
        break;
    end;
    CellG._Break:
    begin
      if loop = true then
      begin
                breCode:=_cellV.genCodeP(CellV.jmp,breCode);
      end else
      begin
                _cellG.error('[vOł');
      end;
        token:=_cellG.checkGet(_cellG.makeToken,CellG._Semicolon);
        break;
    end;
    CellG._Rbrace,CellG.dollar:
        continue;
    else
        token:=_cellG.makeToken;
    end;
  end;
end;

procedure TCellK._condition;
var
  k: integer;
begin
        _expression;
        k:=token.kind;
        token:=_cellG.makeToken;
        _expression;
  case k of
  CellG._Equal2:
        _cellV.genCodeO(CellV.eql);
  CellG._NotEq:
        _cellV.genCodeO(CellV.neq);
  CellG._Lss:
        _cellV.genCodeO(CellV.lss);
  CellG._Gtr:
        _cellV.genCodeO(CellV.gtr);
  CellG._LssEq:
        _cellV.genCodeO(CellV.leq);
  CellG._GtrEq:
        _cellV.genCodeO(CellV.geq);
  else
        _cellG.error('Ɍ肪܂');
  end;
end;

procedure TCellK._term;
var
  k: integer;
  x: Boolean;
begin
        _factor;
  while (token.kind = CellG._Mult)or(token.kind = CellG._Div) do
  begin
        k:=token.kind;
        token:=_cellG.makeToken;
    if (shift = 2)and(k = CellG._Mult) then
    begin
        x:=true;
        shift:=1;
    end else
    begin
        x:=false;
    end;
        _factor;
    if x = true then
    begin
        shift:=2;
    end;
    if shift = 1 then
    begin
      if k = CellG._Mult then
      begin
                _cellV.genCodeO(CellV._mul);
      end else
      begin
                _cellV.genCodeO(CellV._div);
      end;
    end else
    begin
      if k = CellG._Mult then
      begin
                _cellV.genCodeO(CellV.mus);
      end else
      begin
                _cellV.genCodeO(CellV.dis);
      end;
    end;
        sahen:=0;
  end;
end;

procedure TCellK._factor;
var
  i, k, tIndex, pi, ps: integer;
  sa, saI, saC: integer;
  s, t: string;
  p: TRaddr;
begin
  if token.kind = CellG.Num then
  begin
        checkKata(1);
        _cellV.genCodeV(CellV.lit,token.value);
        token:=_cellG.makeToken;
  end else
        if token.kind = CellG.Moji then
  begin
        checkKata(2);
        _cellV.genCodeS(CellV.lis,token.id);
        token:=_cellG.makeToken;
  end else
        if token.kind = CellG._Lparen then
  begin
        token:=_cellG.makeToken;
        _expression;
        token:=_cellG.checkGet(token,CellG._Rparen);
  end else
        if (token.kind = CellG._Plus)or(token.kind = CellG._Minus) then
  begin
        checkKata(1);
        k:=token.kind;
        token:=_cellG.makeToken;
        _factor;
    if k = CellG._Minus then
    begin
        _cellV.genCodeO(CellV.neg);
    end;
  end else
        if token.kind = CellG.Id then
  begin
        tIndex:=_cellG.searchT(token.id);
        k:=_cellG.tKind(tIndex);
    case k of
    CellG.funID,0:
    begin
        s:=_cellG.moduleName;
        t:=token.id;
      if k = 0 then
      begin
                token:=_cellG.makeToken;
        if (token.kind <> CellG._Period)and(token.kind <> CellG._Lparen) then
        begin
          if token.kind = CellG._Equal then
          begin
                sahen:=-1;
                ident:=t;
                saIndex:=_cellG.nextTIndex;
                saCode:=_cellV.genCodeT(CellV.lda,0);
          end else
          begin
                _cellG.error('Ă܂');
          end;
                Exit;
        end else
                if token.kind = CellG._Period then
        begin
                token:=_cellG.makeToken;
          if token.kind <> CellG.Id then
          begin
                _cellG.error('O܂');
                Exit;
          end;
                s:=t;
                t:=token.id;
                tIndex:=_cellG.searchFModule(s,t);
                token:=_cellG.makeToken;
        end;
      end else
      begin
                token:=_cellG.makeToken;
      end;
        pi:=0;
        ps:=0;
        sa:=sahen;
        saI:=saIndex;
        saC:=saCode;
        token:=_cellG.checkGet(token,CellG._Lparen);
      if token.kind <> CellG._Rparen then
      begin
                i:=shift;
                shift:=0;
        while true do
        begin
                _expression;
          if shift = 1 then
          begin
                inc(pi);
          end else
          begin
                inc(ps);
          end;
                shift:=0;
          if token.kind = CellG._Comma then
          begin
                token:=_cellG.makeToken;
                continue;
          end;
                token:=_cellG.checkGet(token,CellG._Rparen);
                break;
        end;
                shift:=i;
      end else
      begin
                token:=_cellG.makeToken;
      end;
      if tIndex = 0 then
      begin
                i:=_cellV.genCodeC(0,0);
        if sa = -1 then
        begin
                sa:=CellG.intID;
        end;
                _cellG.setKariTable(t,s,sa,saI,saC,pi,ps,i);
                sahen:=0;
                Exit;
      end;
      if _cellG.pKazuI(tIndex) <> pi then
      begin
                _cellG.error('̐܂(I)');
      end;
      if _cellG.pKazuS(tIndex) <> ps then
      begin
                _cellG.error('̐܂(S)');
      end;
        i:=_cellG.fModori(tIndex);
      if i = CellG._S then
      begin
                checkKata(2);
      end else
                if i = CellG._I then
      begin
                checkKata(1);
      end else
      begin
                checkKata(0);
      end;
        p:=_cellG.tAddr(tIndex);
        _cellV.genCodeC(p.level,p.addr);
        sahen:=0;
    end;
    else

        sahen:=k;
        saIndex:=tIndex;
        _Sa;
        i:=token.kind;
      if (i = CellG._Plus2)or(i = CellG._Minus2) then
      begin
                sahen:=0;
                token:=_cellG.makeToken;
        if (k = CellG.intID)or(k = CellG.parI)or(k = CellG.arrI) then
        begin
          if k = CellG.arrI then
          begin
            if (token.kind = CellG._Rparen)and(forex = true) then
            begin
              if i = CellG._Plus2 then
              begin
                        _cellV.genCodeO(CellV._inc);
              end else
              begin
                        _cellV.genCodeO(CellV._dec);
              end;
            end else
            begin

              if i = CellG._Plus2 then
              begin
                        _cellV.genCodeO(CellV.lin);
              end else
              begin
                        _cellV.genCodeO(CellV.lde);
              end;

            end;
          end else
          begin

            if (token.kind <> CellG._Rparen)or(forex = false) then
            begin
                _cellV.genCodeT(CellV.lod,tIndex);
            end;
                _cellV.genCodeT(CellV.lda,tIndex);
            if i = CellG._Plus2 then
            begin
                _cellV.genCodeO(CellV.lin);
            end else
            begin
                _cellV.genCodeO(CellV.lde);
            end;

          end;
        end else
        begin
             _cellG.error('^Ɍ肪܂');
        end;
      end;

    end;
  end else
  begin
        _cellG.error('͂܂');
  end;
end;

function TCellK.hairetu(const ti: integer): Boolean;
var
  i, j, sa: integer;
begin
        sa:=sahen;
        token:=_cellG.checkGet(_cellG.makeToken,CellG._Lbracket);
        _expression;
  if token.kind = CellG._Rbracket then
  begin
        token:=_cellG.makeToken;
        i:=1;
        j:=CellV.adv;
  end else
        if token.kind = CellG._Ex then
  begin
        token:=_cellG.makeToken;
        _expression;
        token:=_cellG.checkGet(token,CellG._Rbracket);
        i:=2;
        j:=CellV.arr;
  end else
  begin
        _cellG.error(']or! ܂');
        shift:=0;
        result:=false;
        Exit;
  end;
        sahen:=sa;
        _cellV.genCodeA(j,_cellG.hairetu(ti));
  if _cellG.jigen(ti) <> i then
  begin
        _cellG.error('z̎v܂');
        result:=false;
  end else
  begin
        result:=true;
  end;
end;

procedure TCellK._expression1;
var
  k, s: integer;
begin
        _expression2;
        k:=token.kind;
  if (k <> CellG._Equal2)and(k <> CellG._NotEq)and(k <> CellG._Lss)and(k <> CellG._Gtr)and
    (k <> CellG._LssEq)and(k <> CellG._GtrEq) then
  begin
        Exit;
  end;
        sahen:=0;
        s:=shift;
        shift:=0;
        token:=_cellG.makeToken;
        _expression2;
  if s <> shift then
  begin
        _cellG.error('r̂̌^v܂B');
  end;
  if (s = 2)and((k <> CellG._Equal2)or(k <> CellG._NotEq)) then
  begin
        _cellG.error('̑召r͂ł܂B');
        Exit;
  end;
  case k of
  CellG._Equal2:
    if s = 2 then
    begin
        _cellV.genCodeO(CellV.eqs);
    end else
    begin
        _cellV.genCodeO(CellV.eql);
    end;
  CellG._NotEq:
    if s = 2 then
    begin
        _cellV.genCodeO(CellV.nes);
    end else
    begin
        _cellV.genCodeO(CellV.neq);
    end;
  CellG._Lss:
        _cellV.genCodeO(CellV.lss);
  CellG._Gtr:
        _cellV.genCodeO(CellV.gtr);
  CellG._LssEq:
        _cellV.genCodeO(CellV.leq);
  CellG._GtrEq:
        _cellV.genCodeO(CellV.geq);
  end;
        con:=true;
end;

procedure TCellK._expression2;
var
  k: integer;
begin
        _term;
        k:=token.kind;
  while (token.kind = CellG._Plus)or(token.kind = CellG._Minus) do
  begin
        token:=_cellG.makeToken;
        _term;
    if shift = 1 then
    begin
      if k = CellG._Plus then
      begin
                _cellV.genCodeO(CellV._add);
      end else
      begin
                _cellV.genCodeO(CellV._sub);
      end;
    end else
    begin

      if k = CellG._Plus then
      begin
                _cellV.genCodeO(CellV.ads);
      end else
      begin
                _cellV.genCodeO(CellV.sus);
      end;

    end;
  end;
end;

procedure TCellK.checkKata(t: integer);
begin
  if shift = 0 then
  begin
        shift:=t;
  end else
        if t <> shift then
  begin
        _cellG.error('^v܂B');
  end;
end;

procedure TCellK._Sa;
begin
  case sahen of
  CellG.intID,CellG.parI:
  begin
        checkKata(1);
        token:=_cellG.makeToken;
    if token.kind = CellG._Equal then
    begin
        saCode:=_cellV.genCodeT(CellV.lda,saIndex);
    end else
        if (token.kind <> CellG._Plus2)and(token.kind <> CellG._Minus2) then
    begin
        _cellV.genCodeT(CellV.lod,saIndex);
    end;
  end;
  CellG.strID,CellG.parS:
  begin
        checkKata(2);
        token:=_cellG.makeToken;
    if token.kind = CellG._Equal then
    begin
        saCode:=_cellV.genCodeT(CellV.las,saIndex);
    end else
        if (token.kind <> CellG._Plus2)or(token.kind <> CellG._Minus2) then
    begin
        _cellV.genCodeT(CellV.los,saIndex);
    end;
  end;
  CellG.arrI:
  begin
        checkKata(1);
        _cellV.genCodeT(CellV.lda,saIndex);
    if hairetu(saIndex) = true then
    begin
      if (token.kind <> CellG._Equal2)and(token.kind <> CellG._Plus2)and(token.kind <> CellG._Minus2) then
      begin
                _cellV.genCodeO(CellV.lod);
      end;
    end;
        shift:=1;
  end;
  CellG.arrS:
  begin
        checkKata(2);
        _cellV.genCodeT(CellV.lda,saIndex);
    if hairetu(saIndex) = true then
    begin
      if (token.kind <> CellG._Equal2)and(token.kind <> CellG._Plus2)and(token.kind <> CellG._Minus2) then
      begin
                _cellV.genCodeO(CellV.lds);
      end;
    end;
        shift:=2;
  end;
  end;
end;

procedure TCellK.shokika;
begin
        con:=false;
        saIndex:=0;
        saCode:=0;
        breCode:=0;
        retIS:=false;
        loop:=false;
        shift:=0;
        sahen:=-1;
        ident:='';
        forex:=false;
end;

end.
