#include "branchdatainterpreter.h"
#include "branch.h"
#include <QMessageBox>

BranchDataInterpreter::BranchDataInterpreter() :
        _branch()
{
}

Data* BranchDataInterpreter::Interpret(QList<QString> list, Data *data)
{
    _branch = new Branch(list.takeFirst());

    QVector<int> vector;

    for(int i=0;i<5;++i)
    {
        vector.append(list.value(i).toInt());
    }

    _branch->SetSentouCapability(vector);
    data->Add(_branch);

    return _branch;
}

Data* BranchDataInterpreter::Interpret(QString str, Data * data)
{
    QRegExp branchRegExp("^【(.+)】(/(\\d+/){5})");
    QRegExp capability5("/(\\d+)/(\\d+)/(\\d+)/(\\d+)/(\\d+)/");

    if( branchRegExp.indexIn(str) > -1)
    {
        _branch = new Branch(branchRegExp.cap(1));

        if( capability5.indexIn(branchRegExp.cap(2)) > -1)
        {
            QVector<int> vector;

            for(int i=0;i<5;i++)
            {
                vector.append(capability5.cap(i).toInt());
            }
            /*
                   _branch->SetKihonCapability(vector);

                    vector.fill(0,5);
                    for(int i=6;i<=10;i++)
                    {
                        vector.append(capability.cap(i).toInt(&ok, 10));
                    }
                    */
            _branch->SetSentouCapability(vector);
        }
        else
        {
	    QMessageBox::warning(NULL, tr("Warning"), tr("ブランチの能力値の記述が異常です"), QMessageBox::Ok, QMessageBox::NoButton);
        }
        data->Add(_branch);

        return _branch;
    }
    else
    {
        return GoNext(str, data);
    }

}
