#include "category.h"
#include <QMessageBox>
#include <QDebug>
#include <QHeaderView>

Category::Category(QString name,
                   QVector<int> kihonCapability,
                   QVector<int> sentouCapability,
                   QTableWidget *tokugiTableWidget,
                   QList<Data *> autoGetTokugiList)
    :Data(name),
    _kihonCapability(kihonCapability),
    _sentouCapability(sentouCapability),
    _autoGetTokugiList(autoGetTokugiList)
{
    _tokugiTableWidget = tokugiTableWidget,

    _tokugiTableWidget->setColumnCount(8);
    _tokugiTableWidget->setRowCount(0);
    _tokugiTableWidget->setHorizontalHeaderItem(0, new QTableWidgetItem(QObject::tr("所属"), 0) );
    _tokugiTableWidget->setHorizontalHeaderItem(1, new QTableWidgetItem(QObject::tr("名称"), 0) );
    _tokugiTableWidget->setHorizontalHeaderItem(2, new QTableWidgetItem(QObject::tr("参照"), 0) );
    _tokugiTableWidget->setHorizontalHeaderItem(3, new QTableWidgetItem(QObject::tr("種別"), 0) );
    _tokugiTableWidget->setHorizontalHeaderItem(4, new QTableWidgetItem(QObject::tr("能力値"), 0) );
    _tokugiTableWidget->setHorizontalHeaderItem(5, new QTableWidgetItem(QObject::tr("タイミング"), 0) );
    _tokugiTableWidget->setHorizontalHeaderItem(6, new QTableWidgetItem(QObject::tr("代償"), 0) );
    _tokugiTableWidget->setHorizontalHeaderItem(7, new QTableWidgetItem(QObject::tr("詳細"), 0) );
    _tokugiTableWidget->horizontalHeader()->setResizeMode(QHeaderView::ResizeToContents);
    _tokugiTableWidget->horizontalHeader()->setStretchLastSection(true);

    _tokugiTableWidget->setSelectionBehavior(QAbstractItemView::SelectRows);
    _tokugiTableWidget->setEditTriggers(QAbstractItemView::NoEditTriggers);
    _tokugiTableWidget->setHorizontalScrollMode(QAbstractItemView::ScrollPerPixel);
    QObject::connect(_tokugiTableWidget, SIGNAL(clicked(QModelIndex)),_tokugiTableWidget, SLOT(resizeColumnsToContents() ) );

    _tokugiTableWidget->setVerticalHeaderItem(0, new QTableWidgetItem(QObject::tr("コロナ特技")));
    _tokugiTableWidget->verticalHeader()->setVisible(false);
}

Category::~Category(){
}

bool Category::Add(Data * data)
{
    if(data == NULL)
    {
        return false;
    }
    _childList.append(data);
    data->SetParent(this);
    return true;
}

bool Category::Remove(Data * data)
{
    if(data == NULL)
    {
        return false;
    }
    while(data->GetChild(0)!=NULL)
    {
        data->Remove(data->GetChild(0));
    }
    _childList.removeOne(data);
    return true;
}

Category* Category::GetCategory()
{
    return this;
}

Data* Category::findCategory(QString name)
{
    for(int i=0;this->GetChild(i)!=NULL;++i)
    {
        if(this->GetChild(i)->GetCategory()==NULL)
        {
            continue;
        }
        else if(this->GetChild(i)->GetName() == name)
        {
            return this->GetChild(i);
        }
        else
        {
            Data *data = this->GetChild(i)->findCategory(name);
            if(data!=NULL)
            {
                return data;
            }
        }
    }
    return NULL;
}

QVector<int> Category::GetKihonCapability()
{
    return _kihonCapability;
}

int Category::GetKihonCapability(int i)
{
    return _kihonCapability.at(i);
}

bool Category::SetKihonCapability(QVector<int> kihon)
{
    _kihonCapability = QVector<int>(kihon);
    return true;
}

QVector<int> Category::GetSentouCapability()
{
    return _sentouCapability;
}

int Category::GetSentouCapability(int i)
{
    return _sentouCapability.at(i);
}

bool Category::SetSentouCapability(QVector<int> sentou)
{
    _sentouCapability = QVector<int>(sentou);
    return true;
}

QList<Data*> Category::getAutoGetTokugiList()
{
    return _autoGetTokugiList;
}

bool Category::addAutGetTokugiList(Data *tokugi)
{
    _autoGetTokugiList.append(tokugi);
    return true;
}

QTableWidget* Category::getTokugiTableWidget()
{
    return _tokugiTableWidget;
}

bool Category::setTokugiTableWidget(QTableWidget *qw)
{
    _tokugiTableWidget = qw;
    return true;
}
