#include "categorywindow.h"
#include "category.h"
#include "corona.h"
#include "meme.h"
#include "branch.h"
#include "tokugi.h"
#include <QDebug>
#include <QMessageBox>

CategoryWindow::CategoryWindow(QWidget *parent) :
        QWidget(parent),
        _general(NULL)
{
}

CategoryWindow::~CategoryWindow()
{
}

bool CategoryWindow::setGeneral(Data * data)
{
    _general = data;
    return true;
}

/**
  * 入力：テーブルウィジェット、親データ、子データ格納リスト、カテゴリのクラス
  *　結果：テーブルウィジェットの表示にカテゴリ追加
  * T : category content : Corona, Meme, Branch
  */
template <class T> bool CategoryWindow::addCategory(QTableWidget *qtw, Data *data, QList<Data*>& childList, T*)
{
    try
    {
        if(data == NULL)// data が null のとき
        {
            throw QObject::tr("dataがありません");
        }

        qtw->setRowCount(0); //行数を初期化して0
        for(int i=0;data->GetChild(i)!=NULL;++i) //下層データを漁る
        {
            T* child = dynamic_cast<T*>(data->GetChild(i));
            if(child == NULL)
            {
                continue;
            }
            childList.append(child);
            qtw->setRowCount(qtw->rowCount() + 1);
            qtw->setItem(qtw->rowCount()-1,0,new QTableWidgetItem(child->GetName(), 0));
            int column_num = 1;

            if(!child->GetKihonCapability().isEmpty())
            {
                for(int j=0;j<5;j++)
                {
                    //基本能力の表示
                    qtw->setItem(qtw->rowCount()-1,column_num,new QTableWidgetItem(QString::number(child->GetKihonCapability(j)), 0));
                    column_num++;
                }
            }
            if(!child->GetSentouCapability().isEmpty())
            {
                for(int j=0;j<5;j++)
                {
                    //戦闘能力の表示
                    qtw->setItem(qtw->rowCount()-1,column_num,new QTableWidgetItem(QString::number(child->GetSentouCapability(j)), 0));
                    column_num++;
                }
            }
        }
        return true;
    }
    catch(QString str)
    {
        QMessageBox::warning(qtw, tr("Warning"), str, QMessageBox::Ok, QMessageBox::NoButton);
        return false;
    }
}
template bool CategoryWindow::addCategory(QTableWidget*, Data*, QList<Data*>&, Corona*);
template bool CategoryWindow::addCategory(QTableWidget*, Data*, QList<Data*>&, Meme*);
template bool CategoryWindow::addCategory(QTableWidget*, Data*, QList<Data*>&, Branch*);

/**
 * 入力：　ミームまたはブランチのリストウィジェット、特技のテーブルウィジェット、カテゴリのリスト
 * 出力：　選択されたミームまたはブランチのデータのポインタ
 */
QHash<int, Data*> CategoryWindow::ShowTokugi(QTableWidget* ctw, QTableWidget* ttw, QList<Data*> clist)
{
    Data* gottenCategory = NULL;
    try
    {
        if(ctw == NULL)
        {
            throw QString();
        }
        if(ctw->currentRow() >= clist.size())
        {
            throw tr("不正参照です");
        }

        gottenCategory = clist.at(ctw->currentRow());
        if(gottenCategory == NULL)
        {
            throw tr("ここは空です");
        }

        int baseColumn = -1;
        for(int k=0;k<ttw->columnCount();k++)
        {
            if( ttw->horizontalHeaderItem(k)->text().contains(QObject::tr("所属")) )
            {
                baseColumn = k;
                break;
            }
        }
        if(baseColumn==-1)
        {
            throw tr("所属列が見つかりません");
        }

        ttw->setRowCount(0);
        QHash<int, Data*> tlist;
        for(int i=0,j=0;gottenCategory->GetChild(i)!=NULL;++i)
        {
            Data* tokugi = gottenCategory->GetChild(i);
            if(tokugi->GetTokugi() == NULL)
            {
                continue;
            }
            ttw->setRowCount(ttw->rowCount() + 1);
            //ttw->setVerticalHeaderItem(ttw->rowCount(),new QTableWidgetItem(0));

            tlist.insert(j, tokugi);
            ttw->setItem(j,baseColumn,new QTableWidgetItem( tokugi->GetParent()->GetName(), 0) );

            QVector<QString> tokugiProperty = tokugi->GetProperty();
            //ここの順番を柔軟にしたい
            for(int k=0;k<tokugiProperty.size();++k)
            {
                ttw->setItem(j,k+1,new QTableWidgetItem( tokugiProperty.value(k), 0 ));
            }
            ++j;
        }
        ttw->resizeColumnsToContents();
        return tlist;
    }
    catch(QString str)
    {
        QMessageBox::warning(ctw, tr("Warning"), str, QMessageBox::Ok, QMessageBox::NoButton);
        return QHash<int, Data*>();
    }
}

/**
  * テーブルウィジェットの選択特技データを返す
  T: Corona,Meme,Branch
  input: twc(category widget),twt(tokugi widget), categoryList(category list of each), tokugiList(tokugi list of each)
  output: Tokugi
  */
Data* CategoryWindow::getTokugi(QTableWidget* twc, QTableWidget* twt, QList<Data*> categoryList)
{
    try
    {
        if(twc->currentRow()>=categoryList.size())
        {
            throw tr("選択されていません");
        }

        Data *category = categoryList.at(twc->currentRow());

        //取得特技データ
        Data *selTokugi = NULL;
        for(int i=0,j=0;category->GetChild(i)!=NULL;++i)
        {
            Data* tokugi = category->GetChild(i);
            if( (tokugi->GetTokugi() != NULL) && (j++ == twt->currentRow()) )
            {
                selTokugi = tokugi;
                break;
            }
        }

        //選択特技が存在するかチェック
        if(selTokugi==NULL)
        {
            throw tr("特技のデータがありません");
        }

        return selTokugi;
    }
    catch(QString str)
    {
        QMessageBox::warning(twc, "Warning", str,QMessageBox::Ok, QMessageBox::NoButton);
        return NULL;
    }
}

bool CategoryWindow::setSelectedCategory(Data *data)
{
    _selectedCategory = data;
    return true;
}

Data* CategoryWindow::getSelectedCategory()
{
    return _selectedCategory;
}

/**
  指定されたカテゴリの特技テーブルウィジェットを表示
  */
QTableWidget* CategoryWindow::showTokugiTableWidget(Data *data)
{
    data->getTokugiTableWidget()->show();
    return data->getTokugiTableWidget();
}
