#include "coronadatainterpreter.h"
#include <QMessageBox>
#include <QDebug>

CoronaDataInterpreter::CoronaDataInterpreter()
    :_corona()
{
}

Data* CoronaDataInterpreter::Interpret(QList<QString> list, Data *data)
{
    _corona = new Corona(list.takeFirst());

    QVector<int> vector;

    for(int i=0;i<5;++i)
    {
        vector.append(list.value(i).toInt());
    }
    _corona->SetKihonCapability(vector);

    vector = QVector<int>();
    for(int i=5;i<10;++i)
    {
        vector.append(list.value(i).toInt());
    }
    _corona->SetSentouCapability(vector);

    data->Add(_corona);

    return _corona;
}

Data*CoronaDataInterpreter::Interpret(QString str, Data * data)
{
    QRegExp coronaRegExp("^【(.+)】(/(\\d+/){10})");
    QRegExp capability10("/(\\d+)/(\\d+)/(\\d+)/(\\d+)/(\\d+)/(\\d+)/(\\d+)/(\\d+)/(\\d+)/(\\d+)/");

    if( coronaRegExp.indexIn(str) < 0)
    {
        return GoNext(str, data);
    }


    if( capability10.indexIn(coronaRegExp.cap(2)) > -1)
    {
        QMessageBox::warning(NULL, tr("Warning"), tr("コロナの能力値の記述が異常です"), QMessageBox::Ok, QMessageBox::NoButton);
        return NULL;
    }

    _corona = new Corona(coronaRegExp.cap(1));
    QVector<int> vector;
    bool ok;

    for(int i=0;i<5;i++)
    {
        vector.append(capability10.cap(i).toInt(&ok, 10));
    }
    _corona->SetKihonCapability(vector);

    vector.fill(0,5);
    for(int i=6;i<=10;i++)
    {
        vector.append(capability10.cap(i).toInt(&ok, 10));
    }
    _corona->SetSentouCapability(vector);

    data->Add(_corona);

    return _corona;
}
