#include "coronawindow.h"
#include "ui_coronawindow.h"
#include "corona.h"
#include "tokugi.h"
#include <QTableWidget>
#include <QTableWidgetItem>
#include <QDebug>
#include <QMessageBox>

CoronaWindow::CoronaWindow(CategoryWindow *parent) :
        CategoryWindow(parent),
        ui(new Ui::CoronaWindow),
        _coronaList(),
        _coronaTokugiList(),
        _tokugiTableWidget()
{
    ui->setupUi(this);
    _tokugiTableWidget = ui->CoronaTokugiTableWidget;
    setTableResize();
}

CoronaWindow::~CoronaWindow()
{
    delete ui;
}

void CoronaWindow::changeEvent(QEvent *e)
{
    QWidget::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        //ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void CoronaWindow::resizeEvent(QResizeEvent *)
{
    ui->CoronaTokugiTableWidget->resizeColumnsToContents();
}

/**
  general以下の子コロナを表示
  初期化処理
  */
bool CoronaWindow::addCorona(Data *general)
{
    bool b = addCategory(ui->CoronaTableWidget, general, _coronaList, new Corona);
    foreach(Data *c, _coronaList)
    {
        ui->verticalLayout_2->insertWidget(ui->verticalLayout_2->count() -1, c->getTokugiTableWidget() );
        c->getTokugiTableWidget()->hide();
    }
    return b;
}

bool CoronaWindow::setTableResize()
{
    ui->CoronaTableWidget->horizontalHeader()->setResizeMode(QHeaderView::ResizeToContents);
    ui->CoronaTokugiTableWidget->horizontalHeader()->setResizeMode(QHeaderView::ResizeToContents);
    return true;
}

/*
 slots
 */
/**
  * コロナ取得ボタン
  * 取得コロナを設定
  */
void CoronaWindow::on_GetCoronaButton_clicked()
{
    Data *selCorona = _coronaList.at(ui->CoronaTableWidget->currentRow());

    //to MainWindow::GetSelectedCorona
    //for displaying corona
    emit selectedCorona(selCorona);
    return;
}

/**
  * 特技取得ボタン
  * 取得コロナ下に取得特技を追加する
  */
void CoronaWindow::on_GetCoronaTokugiButton_clicked()
{
    //to MainWindow::GetSelecetedCoronaTokugi
    emit selectedCoronaTokugi( getTokugi(ui->CoronaTableWidget, _tokugiTableWidget, _coronaList) );
}

/**
  クリックされたコロナ以下の特技をコロナ特技欄に表示
  */
void CoronaWindow::on_CoronaTableWidget_clicked(QModelIndex index)
{
    _tokugiTableWidget->hide();
    _tokugiTableWidget = showTokugiTableWidget(_coronaList.at(ui->CoronaTableWidget->currentRow()) );

    //リサイズ
    ui->CoronaTableWidget->resizeColumnsToContents();
}

/**
  リサイズ
  */
void  CoronaWindow::on_CoronaTokugiTableWidget_cellClicked(int row, int column)
{
    ui->CoronaTokugiTableWidget->resizeColumnToContents(column);
}
