#include "data.h"
#include "grouping.h"
#include "category.h"
#include "soubi.h"

QVector<SoubiSlot*>* Data::_slotsVector =NULL;

Data::Data(QString name,
           Data *parent,
           QList<Data *> childList,
           bool isOwned,
           QList<Data *> ownChildList,
           QList<Data*> childGroupingList)
    :_name(name),
    _parent(parent),
    _childList(childList),
    _isOwned(isOwned),
    _ownChildList(ownChildList),
    _childGroupingList(childGroupingList)
{
}

Data::~Data()
{
}

//common
bool Data::Add(Data * data)
{
    return false;
}

bool Data::Remove(Data * data)
{
    return false;
}

Category* Data::GetCategory()
{
    return NULL;
}

Tokugi* Data::GetTokugi()
{
    return NULL;
}

Grouping* Data::GetGrouping()
{
    return NULL;
}

Soubi* Data::GetSoubi()
{
    return NULL;
}

QList<Data*> Data::GetParents()
{
    return QList<Data*>();
}

bool Data::AddParent(Data *parent)
{
    return false;
}

QString Data::GetName()
{
    return _name;
}

bool Data::SetName(QString name)
{
    _name = name;
    return true;
}

Data* Data::GetChild(int number)
{
    return _childList.value(number);
}

Data* Data::GetParent()
{
    if(_parent == NULL)
    {
        return NULL;
    }
    return _parent;
}

bool Data::SetParent(Data* data)
{
    _parent = data;
    return true;
}

bool Data::IsOwned()
{
    return _isOwned;
}

bool Data::SetOwned(bool isOwned)
{
    _isOwned = isOwned;
    return true;
}

bool Data::OwnAdd(Data *data)
{
    if(data==NULL)
    {
        return false;
    }
    data->SetOwned(true);
    _ownChildList.append(data);
    return true;
}

bool Data::OwnRemove(Data *data)
{
    if(data == NULL)
    {
        return false;
    }
    while(data->GetOwnChild(0)!=NULL)
    {
        data->OwnRemove(data->GetOwnChild(0));
    }
    data->SetOwned(false);
    _ownChildList.removeOne(data);
    return true;
}

Data* Data::GetOwnChild(int number)
{
    return _ownChildList.value(number);
}

/**
  this以下のT*型のオブジェクトをlistに格納する
  */
template<class T> bool Data::findAll(QList<T*> &list)
{
    Data *child = NULL;
    for(short i=0;GetChild(i)!=NULL;++i)
    {
        child = GetChild(i);
        if(dynamic_cast<T*>(child)!=NULL)
        {
            list.append(dynamic_cast<T*>(child));
        }
        child->findAll(list);
    }
    return true;
}
template bool Data::findAll(QList<Grouping *> &list);
template bool Data::findAll(QList<Soubi *> &list);

bool Data::setSoubiSlots(QVector<SoubiSlot*> *slotsVector)
{
    _slotsVector = slotsVector;
    return true;
}

QVector<SoubiSlot*>* Data::getSoubiSlot()
{
    return _slotsVector;
}

/*
QList<Data*> Data::GetChildGrouping()
{
    return _childGroupingList;
}

bool Data::AddChildGrouping(Data* grouping)
{
    _childGroupingList.append(grouping);
    return false;
}
*/

//Category
Data* Data::findCategory(QString name)
{
    return NULL;
}

QVector<int> Data::GetKihonCapability()
{
    return QVector<int>();
}

int Data::GetKihonCapability(int)
{
    return NULL;
}

bool Data::SetKihonCapability(QVector<int>)
{
    return false;
}

QVector<int> Data::GetSentouCapability()
{
    return QVector<int>();
}

int Data::GetSentouCapability(int)
{
    return NULL;
}

bool Data::SetSentouCapability(QVector<int>)
{
    return false;
}

QList<Data*> Data::getAutoGetTokugiList()
{
    return QList<Data*>();
}

bool Data::addAutGetTokugiList(Data*)
{
    return false;
}

QTableWidget* Data::getTokugiTableWidget()
{
    return NULL;
}

bool Data::setTokugiTableWidget(QTableWidget *)
{
    return false;
}

//Tokugi
QString Data::GetReference()
{
    return NULL;
}
bool Data::SetReference(QString reference)
{
    return false;
}
QString Data::GetType()
{
    return NULL;
}
bool Data::SetType(QString)
{
    return false;
}
QString Data::GetCapability()
{
    return NULL;
}

bool Data::SetCapability(QString)
{
    return false;
}
QString Data::GetTiming()
{
    return NULL;
}
bool Data::SetTiming(QString timing)
{
    return false;
}
QString Data::GetCost()
{
    return NULL;
}
bool Data::SetCost(QString cost)
{
    return false;
}
QString Data::GetDetail()
{
    return NULL;
}
bool Data::SetDetail(QString detail)
{
    return false;
}
bool Data::AddDetail(QString detail)
{
    return false;
}

QVector<QString> Data::GetProperty()
{
    return QVector<QString>();
}

unsigned short Data::GetTotalInitialLevel()
{
    return 0;
}

unsigned short Data::GetTotalExperimentalLevel()
{
    return 0;
}

unsigned short Data::GetInitialLevel()
{
    return 0;
}

bool Data::IncreaseInitialLevel()
{
    return false;
}
bool Data::DecreaseInitialLevel()
{
    return false;
}

unsigned short Data::GetExperimentalLevel()
{
    return 0;
}
bool Data::IncreaseExperimentalLevel()
{
    return false;
}
bool Data::DecreaseExperimentalLevel()
{
    return false;
}


