#ifndef DATA_H
#define DATA_H
#include <QList>
#include <QVector>
#include <QString>
#include <QTableWidget>

class Category;
class Tokugi;
class Grouping;
class Soubi;
class SoubiSlot;

class Data
{
public:
    Data(QString name = QString(""),
         Data *parent = NULL,
         QList<Data*> childList = QList<Data*>(),
         bool isOwned = false,
         QList<Data*> ownChildList = QList<Data*>(),
         QList<Data*> childGroupingList = QList<Data*>());
    virtual ~Data();

    //Common
    //NULL
    virtual bool Add(Data *data);
    virtual bool Remove(Data *data);
    virtual Category* GetCategory();
    virtual bool getMeme(){return false;}
    virtual bool getBranch(){return false;}
    virtual Tokugi* GetTokugi();
    virtual Grouping* GetGrouping();
    virtual Soubi* GetSoubi();
    virtual QList<Data*> GetParents();
    virtual bool AddParent(Data *parent);
    //Defined
    virtual QString GetName();
    virtual bool SetName(QString);
    virtual Data* GetChild(int number);
    virtual Data* GetParent();
    virtual bool SetParent(Data *parent);
    virtual bool IsOwned();
    virtual bool SetOwned(bool isOwned);
    virtual bool OwnAdd(Data* data);
    virtual bool OwnRemove(Data* data);
    virtual Data* GetOwnChild(int number);
    template<class T> bool findAll(QList<T*> &list);

    //static bool setBuiSize(unsigned short i){return false;}
    //virtual unsigned short getBuiSize(){return 0;}
    static bool setPartAndBui(QMultiMap<unsigned short, unsigned short> m){return false;}
    virtual QMultiMap<unsigned short, unsigned short> getPartAndBui(){return QMultiMap<unsigned short, unsigned short>();}

    static bool setSoubiSlots(QVector<SoubiSlot*> *slotsVector);
    virtual QVector<SoubiSlot*>* getSoubiSlot();

    //virtual QList<Data*> GetChildGrouping();
    //virtual bool AddChildGrouping(Data *grouping);

    //Category
    virtual Data* findCategory(QString name);
    virtual bool SetKihonCapability(QVector<int>);
    virtual QVector<int> GetKihonCapability();
    virtual int GetKihonCapability(int);
    virtual bool SetSentouCapability(QVector<int>);
    virtual QVector<int> GetSentouCapability();
    virtual int GetSentouCapability(int);
    virtual bool addAutGetTokugiList(Data*);
    virtual QList<Data*> getAutoGetTokugiList();
    virtual bool setTokugiTableWidget(QTableWidget*);
    virtual QTableWidget* getTokugiTableWidget();
    virtual bool setSelectedCategory(Data*){return false;}
    virtual Data* getSelectedCategory(){return NULL;}

    //Tokugi
    virtual QString GetReference();
    virtual bool SetReference(QString);
    virtual QString GetType();
    virtual bool SetType(QString);
    virtual QString GetCapability();
    virtual bool SetCapability(QString);
    virtual QString GetTiming();
    virtual bool SetTiming(QString);
    virtual QString GetCost();
    virtual bool SetCost(QString);
    virtual QString GetDetail();
    virtual bool SetDetail(QString);
    virtual bool AddDetail(QString);
    virtual QVector<QString> GetProperty();

    virtual unsigned short GetTotalInitialLevel();
    virtual unsigned short GetTotalExperimentalLevel();
    virtual unsigned short GetInitialLevel();
    virtual unsigned short GetExperimentalLevel();
    virtual bool IncreaseInitialLevel();
    virtual bool DecreaseInitialLevel();
    virtual bool IncreaseExperimentalLevel();
    virtual bool DecreaseExperimentalLevel();

    //Grouping
    virtual bool addSoubiOfBui(unsigned i, Data* soubi){return false;}
    virtual QList<Data*>* getSoubiOfBui(unsigned short i){return NULL;}
    virtual QTableWidget* getSoubiTableWidget(){return NULL;}

    //Soubi
    virtual QString GetPurchaseCost(){return 0;}
    virtual bool SetPurchaseCost(QString value){return false;}
    virtual QString GetRegularCost(){return 0;}
    virtual bool SetRegularCost(QString value){return false;}
    virtual QString GetPart(){return NULL;}
    virtual bool SetPart(QString part){return false;}
    //virtual QString GetCapability(){return NULL;}
    //virtual bool SetCapability(QString capability){return false;}
    virtual QString GetKoudou(){return NULL;}
    virtual bool SetKoudou(QString koudou){return false;}
    virtual QString GetDamage(){return NULL;}
    virtual bool SetDamage(QString damage){return false;}
    virtual QString GetHP(){return NULL;}
    virtual bool SetHP(QString hp){return false;}
    virtual QString GetRange(){return NULL;}
    virtual bool SetRange(QString range){return false;}
    //virtual QString GetDetail(){return NULL;}
    //virtual bool SetDetail(QString detail){return false;}
    //virtual QString GetReference(){return NULL;}
    //virtual bool SetReference(QString reference){return false;}
    virtual bool addBuiKind(QString str){return false;}
    virtual QString getBuiKind(unsigned short i){return NULL;}
    static bool addBuiKind(unsigned short i, QString str){return false;}
    virtual bool checkBuiKind(unsigned short i){return false;}

protected:
    static QVector<SoubiSlot*> *_slotsVector;
    QString _name;
    Data* _parent;
    QList<Data*> _childList;
    bool _isOwned;
    QList<Data*> _ownChildList;
    QList<Data*> _childGroupingList;
};

#endif // DATA_H   
