#include "filedatareader.h"
#include "filedatainterpreter.h"
#include "filedataregexp.h"
#include "coronadatainterpreter.h"
#include <QDebug>
#include <QMessageBox>
#include <QFile>
#include <QTextStream>
#include <QDir>

FileDataReader::FileDataReader()
{
}

FileDataReader* FileDataReader::_singlton = NULL;
FileDataReader* FileDataReader::GetInstance()
{
    if(_singlton == NULL)
    {
         _singlton = new FileDataReader;
    }
    return _singlton;
}

/**
  設定ファイル読込
  入力：ファイル名、最上位データ
  */
bool FileDataReader::Read(QString filename, Data* data)
{
    try
    {
        FileDataRegExp* _fire = FileDataRegExp::getInstance();
        _fire->Initialize();

        QFile file(filename);

        if(!file.open(QIODevice::ReadOnly | QIODevice::Text))
        {
            throw tr("ファイル読み込みエラー");
        }
        int i =0;
        QString qline;
        while (!file.atEnd()) //1行ずつ判別
        {
            ++i;
            qline = file.readLine();
            qline.remove(QRegExp("\\n"));
            if(qline.size()==0)
            {
                continue;
            }
            //  fdi->Check(line); //正規表現を用いた判別チェック
            if( !_fire->Define(qline, data) ) // FileDataRegExpが一括
            {
                return false;
            }
            //Chain of Responsibility で回す
            //CoronaDataInterpreter _cdi
            //_cdi->Interpret(str, data);

        }
        return true;
    }
    catch(QString str)
    {
        QMessageBox::warning(NULL, tr("Warning"), str, QMessageBox::Ok, QMessageBox::NoButton);
        return false;
    }
}
