#include "filedataregexp.h"
#include <QStringList>
#include <QMessageBox>
#include <QDebug>
#include <QTextCodec>
#include "corona.h"
#include "meme.h"
#include "branch.h"
#include "tokugi.h"
#include "grouping.h"
#include "soubi.h"

FileDataRegExp* FileDataRegExp::_singlton = NULL;

Data* FileDataRegExp::_active = NULL;
Data* FileDataRegExp::_corona = NULL;
Data* FileDataRegExp::_meme = NULL;
Data* FileDataRegExp::_branch = NULL;
Data* FileDataRegExp::_tokugi = NULL;
Data* FileDataRegExp::_grouping = NULL;
Data* FileDataRegExp::_soubi = NULL;

FileDataInterpreter *FileDataRegExp::_interpreter = NULL;
CoronaDataInterpreter *FileDataRegExp::_ci = new CoronaDataInterpreter;
MemeDataInterpreter *FileDataRegExp::_mi = new MemeDataInterpreter;
BranchDataInterpreter *FileDataRegExp::_bi = new BranchDataInterpreter;
TokugiDataInterpreter *FileDataRegExp::_ti = new TokugiDataInterpreter;
GroupingDataInterpreter *FileDataRegExp::_gi = new GroupingDataInterpreter;
SoubiDataInterpreter *FileDataRegExp::_si = new SoubiDataInterpreter;

QRegExp FileDataRegExp::_coronaRegExp;
QRegExp FileDataRegExp::_memeRegExp;
QRegExp FileDataRegExp::_branchRegExp;
QRegExp FileDataRegExp::_capability10;
QRegExp FileDataRegExp::_capability5;
QRegExp FileDataRegExp::_tokugi2;
QRegExp FileDataRegExp::_tokugi1;
QRegExp FileDataRegExp::_tokugiDetail;
QRegExp FileDataRegExp::_groupingRegExp;
QRegExp FileDataRegExp::_soubiRegExp;

FileDataRegExp::FileDataRegExp()
{
}

FileDataRegExp* FileDataRegExp::getInstance()
{
    if(_singlton == NULL)
    {
        _singlton = new FileDataRegExp;

        FileDataRegExp::_coronaRegExp = QRegExp(tr("^【(.+)】(/(\\d+/){10})"));
        FileDataRegExp::_memeRegExp = QRegExp(tr("^#(.+)(/(\\d+/){5})"));
        FileDataRegExp::_branchRegExp = QRegExp(tr("^【(.+)】(/(\\d+/){5})"));
        FileDataRegExp::_capability10 = QRegExp(tr("/(\\d+)/(\\d+)/(\\d+)/(\\d+)/(\\d+)/(\\d+)/(\\d+)/(\\d+)/(\\d+)/(\\d+)/"));
        FileDataRegExp::_capability5 = QRegExp(tr("/(\\d+)/(\\d+)/(\\d+)/(\\d+)/(\\d+)/"));
        FileDataRegExp::_tokugi2 = QRegExp(tr("^【([^／]+)／([^／]+)／([^／]+)／([^／]+)／([^／]+)】(.+$)"));
        FileDataRegExp::_tokugi1 = QRegExp(tr("^【([^(／)]+)／([^(／)]+)／([^(／)]+)／([^(／)]+)】(.+$)"));
        FileDataRegExp::_tokugiDetail = QRegExp(tr("[(　)\\s]*([^(　)\\s]*)[(　)\\s]*$"));
        FileDataRegExp::_groupingRegExp = QRegExp(tr("^#([^/]+)((/[^/]+)*)"));
        FileDataRegExp::_soubiRegExp = QRegExp(tr("(.+)（(.*：)?(.*)／(.*：)?(.*)／(.*：)?(.*)／(.*：)?([^\\d]*\\d*)／(.*：)?([^\\d]*\\d*[＊●]?)／(.*：)?(.*)／(.*：)?([^\\d)]?\\d*)／(.*：)?(.*)／([^：]*：)?(.*)／(.*：)?(.*)）"));

        _tokugi2.setMinimal(true);
        _tokugi1.setMinimal(true);
    }
    return _singlton;
}

bool FileDataRegExp::Initialize()
{
    _active = NULL;
    _corona = NULL;
    _meme = NULL;
    _branch = NULL;
    _tokugi = NULL;
    _grouping = NULL;
    _soubi = NULL;
    _interpreter = NULL;

    return true;
}

/**
  読込行の解釈
  */
bool FileDataRegExp::Define(QString str, Data *general)
{
    if(_active == NULL)
    {
        _active = general;
    }
    if( _coronaRegExp.indexIn(str) > -1)
    {
        _interpreter = _ci;

        QList<QString> list;
        list << _coronaRegExp.cap(1);

        if( _capability10.indexIn(_coronaRegExp.cap(2)) > -1)
        {
            for(int i=1;i<=10;i++)
            {
                list << _capability10.cap(i);
            }
        }
        _corona = _interpreter->Interpret(list, general); //読み込みからインスタンス生成
        _active = _corona;
    }
    else if( _memeRegExp.indexIn(str) > -1)
    {
        _interpreter = _mi;
        QList<QString> list;
        list << _memeRegExp.cap(1);
        if( _capability5.indexIn(_memeRegExp.cap(2)) > -1)
        {
            for(int i=1;i<=5;i++)
            {
                list << _capability5.cap(i);
            }
        }
        _meme = _interpreter->Interpret(list, general); //読み込みからインスタンス生成
        _active = _meme;
    }
    else if( _branchRegExp.indexIn(str) > -1)
    {
        _interpreter = _bi;
        QList<QString> list;
        list << _branchRegExp.cap(1);
        if( _capability5.indexIn(_branchRegExp.cap(2)) > -1)
        {
            for(int i=1;i<=5;++i)
            {
                list << _capability5.cap(i);
            }
        }
        _branch = _interpreter->Interpret(list, _meme); //読み込みからインスタンス生成
        _active = _branch;
    }
    else if( _tokugi2.indexIn(str) > -1)
    {
        //1name2reference3type4capability5timing6cost7detail
        _interpreter = _ti;
        QList<QString> list;
        list.append(_tokugi2.cap(6));
        for(int i=1;i<=5;i++)
        {
            list.append(_tokugi2.cap(i));
        }
        _tokugi = _interpreter->Interpret(list, _active); //読み込みからインスタンス生成
    }
    else if( _tokugi1.indexIn(str) > -1)
    {
        _interpreter = _ti;
        QList<QString> list;
        list.append(_tokugi1.cap(5));
        for(int i=1;i<=6;++i)
        {
            if(i == 2)
            {
                list.append(QString("-"));
            }
            list.append(_tokugi1.cap(i));
        }
        _tokugi = _interpreter->Interpret(list, _active); //読み込みからインスタンス生成
    }
    else if( _groupingRegExp.indexIn(str) > -1)
    {
        _interpreter = _gi;
        //カテゴリ名
        QList<QString> list;
        list.append(_groupingRegExp.cap(1));
        if(_groupingRegExp.cap(2).count() == 0)
        {
            //所属ミーム・ブランチ名を検索
            Data *data = general->findCategory(_groupingRegExp.cap(1));
            if(data != NULL)
            {
                _grouping = _gi->Interpret(list, data);
            }
            else
            {
                _grouping = _gi->Interpret( list, general);
            }
        }
        else
        {
            //所属ミーム・ブランチ名を検索
            QStringList slist = _groupingRegExp.cap(2).remove(0,1).split(tr("/"));
            Data *data;
            bool b = true;
            for(int i=0;i<slist.size();++i)
            {
                data = general->findCategory(slist.at(i));
                if(data != NULL)
                {
                    _grouping = _interpreter->Interpret(list, data);
                    b = false;
                }
            }
            if(b)
            {
                _grouping = _interpreter->Interpret(list, general);
            }
        }
        _active = _grouping;
    }
    else if( _soubiRegExp.indexIn(str) > -1)
    {
        _interpreter = _si;
        QList<QString> list;

        /*
         _soubiRegExp.cap(0) は正規表現パターン全体
         */
        for(int i=1;i<=_soubiRegExp.captureCount();++i)
        {
            switch(i)
            {
            case 1:
            case 3:
            case 5:
            case 7:
            case 9:
            case 11:
            case 13:
            case 15:
            case 17:
            case 19:
            case 21:
                list.append( (_soubiRegExp.cap(i).size() > 0) ? _soubiRegExp.cap(i) : QString("-") );
                break;
            default:
                break;
            }
        }
        _soubi = _interpreter->Interpret(list, _active);
    }
    else if( _tokugiDetail.indexIn(str) > -1)
    {
        if(_tokugi != NULL)
        {
            _interpreter->Interpret(_tokugiDetail.cap(1), _tokugi); //読み込みからインスタンス生成
        }
        else
        {
            int ret = QMessageBox::warning(NULL, tr("Warning"), tr("なんらかの文法エラー\nまたは文字コエンードがutf-8でないかもしれない\n") += str, QMessageBox::Ok | QMessageBox::Abort, QMessageBox::NoButton);
            switch(ret)
            {
            case QMessageBox::Ok:
                break;
            case QMessageBox::Abort:
                return false;
                break;
            default:
                return false;
                break;
            }
        }
    }
    else
    {
        QMessageBox::warning(NULL, tr("Warning"), tr("ファイル読み込み正規表現で何らかのエラー\n") += str, QMessageBox::Ok, QMessageBox::NoButton);
    }
    return true;
}
