#ifndef FILEDATAREGEXP_H
#define FILEDATAREGEXP_H
#include "data.h"
#include "filedatainterpreter.h"
#include "coronadatainterpreter.h"
#include "memedatainterpreter.h"
#include "branchdatainterpreter.h"
#include "tokugidatainterpreter.h"
#include "groupingdatainterpreter.h"
#include "soubidatainterpreter.h"

class FileDataRegExp : public QObject
{
public:
    static FileDataRegExp* getInstance();
    virtual bool Initialize();
    virtual bool Define(QString str, Data * data);

private:
    FileDataRegExp();
    static FileDataRegExp* _singlton;

    static Data* _active;
    static Data* _corona;
    static Data* _meme;
    static Data* _branch;
    static Data* _tokugi;
    static Data* _grouping;
    static Data* _soubi;

    static FileDataInterpreter *_interpreter;
    static CoronaDataInterpreter *_ci;
    static MemeDataInterpreter *_mi;
    static BranchDataInterpreter *_bi;
    static TokugiDataInterpreter *_ti;
    static GroupingDataInterpreter *_gi;
    static SoubiDataInterpreter *_si;

    static QRegExp _coronaRegExp;
    static QRegExp _memeRegExp;
    static QRegExp _branchRegExp;
    static QRegExp _capability10;
    static QRegExp _capability5;
    static QRegExp _tokugi2;
    static QRegExp _tokugi1;
    static QRegExp _tokugiDetail;
    static QRegExp _groupingRegExp;
    static QRegExp _soubiRegExp;
};

#endif // FILEDATAREGEXP_H
