#include "grouping.h"
#include <QHeaderView>
#include <QDebug>

Grouping::Grouping(QString name,
                   QList<Data *> parentList)
                       :Data(name),
                       _parentList(parentList),
                       _soubiVectorOfEachBui(new QVector<QList<Data*> *>),
                       _soubiTableWidget(new QTableWidget(0, 12))
{
    _soubiTableWidget->setHorizontalHeaderItem(0, new QTableWidgetItem(QObject::tr("分類"), 0) );
    _soubiTableWidget->setHorizontalHeaderItem(1, new QTableWidgetItem(QObject::tr("装備名"), 0) );
    _soubiTableWidget->setHorizontalHeaderItem(2, new QTableWidgetItem(QObject::tr("購入"), 0) );
    _soubiTableWidget->setHorizontalHeaderItem(3, new QTableWidgetItem(QObject::tr("常備化"), 0) );
    _soubiTableWidget->setHorizontalHeaderItem(4, new QTableWidgetItem(QObject::tr("部位"), 0) );
    _soubiTableWidget->setHorizontalHeaderItem(5, new QTableWidgetItem(QObject::tr("必要能力値"), 0) );
    _soubiTableWidget->setHorizontalHeaderItem(6, new QTableWidgetItem(QObject::tr("行動値修正"), 0) );
    _soubiTableWidget->setHorizontalHeaderItem(7, new QTableWidgetItem(QObject::tr("ダメージ"), 0) );
    _soubiTableWidget->setHorizontalHeaderItem(8, new QTableWidgetItem(QObject::tr("HP修正"), 0) );
    _soubiTableWidget->setHorizontalHeaderItem(9, new QTableWidgetItem(QObject::tr("射程"), 0) );
    _soubiTableWidget->setHorizontalHeaderItem(10, new QTableWidgetItem(QObject::tr("備考"), 0) );
    _soubiTableWidget->setHorizontalHeaderItem(11, new QTableWidgetItem(QObject::tr("参照"), 0) );

    _soubiTableWidget->horizontalHeader()->setResizeMode(QHeaderView::ResizeToContents);
    _soubiTableWidget->horizontalHeader()->setStretchLastSection(true);
    _soubiTableWidget->verticalHeader()->setVisible(false);
    _soubiTableWidget->setSelectionBehavior(QAbstractItemView::SelectRows);
    _soubiTableWidget->setEditTriggers(QAbstractItemView::NoEditTriggers);
    _soubiTableWidget->setHorizontalScrollMode(QAbstractItemView::ScrollPerPixel);
    _soubiTableWidget->hide();
    QObject::connect(_soubiTableWidget, SIGNAL(clicked(QModelIndex)), _soubiTableWidget, SLOT(resizeColumnsToContents()));
}

Grouping::~Grouping()
{
}

bool Grouping::Add(Data *data)
{
    if(data == NULL)
    {
        return false;
    }
    _childList.append(data);
    data->SetParent(this);
    return true;
}

bool Grouping::Remove(Data *data)
{
    if(data == NULL)
    {
        return false;
    }
    _childList.removeOne(data);
    return true;
}

Data* Grouping::GetChild(int number)
{
    return _childList.value(number);
}

Grouping* Grouping::GetGrouping()
{
    return this;
}

QList<Data*> Grouping::GetParents()
{
    return _parentList;
}

bool Grouping::AddParent(Data *parent)
{
    _parentList.append(parent);
    return true;
}

bool Grouping::addSoubiOfBui(unsigned i, Data *soubi)
{
    if(_soubiVectorOfEachBui->size()<=(int)i)
    {
        _soubiVectorOfEachBui->resize(i+1);
    }
    if(_soubiVectorOfEachBui->at(i)==NULL)
    {
        _soubiVectorOfEachBui->replace(i, new QList<Data*>());
    }
    _soubiVectorOfEachBui->value(i)->append(soubi);
    return true;
}

/**
  入力：部位の指標
  出力：この分類に属する指標で示された部位である装備のリスト
  */
QList<Data*>* Grouping::getSoubiOfBui(unsigned short i)
{
    if(i<_soubiVectorOfEachBui->size())
    {
        return _soubiVectorOfEachBui->at(i);
    }
    else
    {
        return NULL;
    }
}

QTableWidget* Grouping::getSoubiTableWidget()
{
    return _soubiTableWidget;
}
