#include <QtGui/QApplication>
#include <QString>
#include <QDebug>
#include <QTextCodec>
#include <QMessageBox>

#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "coronawindow.h"
#include "memewindow.h"
#include "possibletokugiform.h"
#include "soubiform.h"
#include "category.h"
#include "filedatareader.h"
#include "soubislot.h"

int main(int argc, char *argv[])
{
    QTextCodec::setCodecForTr(QTextCodec::codecForName("utf-8"));
    QTextCodec::setCodecForCStrings(QTextCodec::codecForName("utf-8"));
    QApplication a(argc, argv);
    try
    {

        //一版の作成　この下に色々なデータを詰め込む
        Category* general = new Category(QString("一般"));

        FileDataReader* dr = FileDataReader::GetInstance();

        if(! dr->Read(QString("Corona.txt"), general) )
        {
            throw QObject::tr("Corona.txt 読み込み時エラーのため終了します。");
        }
        if(! dr->Read(QString("Meme.txt"), general) )
        {
            throw QObject::tr("Meme.txt 読み込み時エラーのため終了します。");
        }

        //装備に関する設定
        //その内に外部ファイルから設定したい
        //部位の名前の略称を登録
        for(unsigned short i=0;i<6;++i)
        {
            switch(i)
            {
            case 0:
                {
                    SoubiSlot::addBuiName(i, QObject::tr("片手"));
                    SoubiSlot::addBuiName(i, QObject::tr("片"));
                    break;
                }
            case 1:
                {
                    SoubiSlot::addBuiName(i, QObject::tr("両手"));
                    SoubiSlot::addBuiName(i, QObject::tr("両"));
                    break;
                }
            case 2:
                {
                    SoubiSlot::addBuiName(i, QObject::tr("胴部"));
                    SoubiSlot::addBuiName(i, QObject::tr("胴"));
                    break;
                }
            case 3:
                {
                    SoubiSlot::addBuiName(i, QObject::tr("乗り物"));
                    SoubiSlot::addBuiName(i, QObject::tr("乗"));
                    break;
                }
            case 4:
                {
                    SoubiSlot::addBuiName(i, QObject::tr("その他"));
                    SoubiSlot::addBuiName(i, QObject::tr("そ"));
                    SoubiSlot::addBuiName(i, QObject::tr("他"));
                    break;
                }
            case 5:
                {
                    SoubiSlot::addBuiName(i, QObject::tr("一般装備"));
                    break;
                }
            default:
                break;
            }
        }

        //装備箇所と部位を結びつける
        QMultiMap<unsigned short, unsigned short> *map = SoubiSlot::getPartAndBuiNumbersMap();
        map->insert(0, 0);
        map->insert(0, 1);
        map->insert(1, 0);
        map->insert(1, 1);
        map->insert(2, 2);
        map->insert(3, 3);
        map->insert(4, 4);
        for(unsigned short i=5;i<8;++i)
        {
            for(unsigned short j=0;j<5;++j)
            {
                map->insert(i, j);
            }
        }

        //装備の装備箇所名を登録
        QVector<QString> *partName = new QVector<QString>(8);
        partName->replace(0, QObject::tr("右手"));
        partName->replace(1, QObject::tr("左手"));
        partName->replace(2, QObject::tr("胴部"));
        partName->replace(3, QObject::tr("乗り物"));
        partName->replace(4, QObject::tr("その他"));
        partName->replace(5, QObject::tr("予備１"));
        partName->replace(6, QObject::tr("予備２"));
        partName->replace(7, QObject::tr("予備３"));

        QVector<SoubiSlot*> *slotVector = new QVector<SoubiSlot*>(partName->size());
        Data::setSoubiSlots(slotVector);

        //部位の名前の略称を設定
        for(unsigned short i=0;i<SoubiSlot::getBuiSize();++i)
        {
            for(unsigned short j=0;j<SoubiSlot::getBuiNamesVector(i).size();++j)
            {
                Soubi::addBuiKind(i, SoubiSlot::getBuiNamesVector(i).at(j));
            }
        }

        for(unsigned short i=0;i<partName->size();++i)
        {
            slotVector->replace(i, new SoubiSlot(partName->at(i)));
        }

        if(! dr->Read(QString("Item.txt"), general) )
        {
            throw QObject::tr("Item.txt 読み込み時エラーのため終了します。");
        }

        //各種ウィンドウの生成
        CoronaWindow cw;
        cw.setWindowTitle(QObject::tr("コロナ"));
        cw.setGeneral(general);
        cw.addCorona(general);
        cw.setAttribute(Qt::WA_QuitOnClose, false);
        //cw.show();

        MemeWindow mw;
        mw.setWindowTitle(QObject::tr("ミーム・ブランチ"));
        mw.setGeneral(general);
        mw.addMeme(general);
        mw.setAttribute(Qt::WA_QuitOnClose, false);
        //mw.show();

        PossibleTokugiForm ptf;
        ptf.setWindowTitle(QObject::tr("取得可能特技"));
        ptf.addTokugi(general);
        ptf.setAttribute(Qt::WA_QuitOnClose, false);
        //ptf.show();

        SoubiForm sf;
        sf.setWindowTitle(QObject::tr("装備"));
        sf.setSoubiSlot(slotVector);
        sf.setOwnGeneral(general);
        sf.setAttribute(Qt::WA_QuitOnClose, false);
        //sf.show();

        MainWindow w;
        w.setWindowTitle(QObject::tr("CFCharaMaker"));
        w.setGeneral(general);
        w.setSoubiSlots(slotVector);
        w.setCoronaWindow(&cw);
        w.setMemeWindow(&mw);
        w.setPossibleTokugiForm(&ptf);
        w.setSoubiForm(&sf);
        w.setOwnGeneral(general);
        //w.setAttribute(Qt::WA_DeleteOnClose, QObject::true); //これを使ってもアプリケーションが終了しない
        //QObject::connect(&w, SIGNAL(destroyed(QObject*)), &a, SLOT(quit()));
        w.show();

        QObject::connect( &cw, SIGNAL(selectedCorona(Data*)), &w, SLOT(GetSelectedCorona(Data*)));
        QObject::connect( &cw, SIGNAL(selectedCoronaTokugi(Data*) ), &w, SLOT( GetSelectedCoronaTokugi(Data*) ) );

        QObject::connect( &mw, SIGNAL(selectedMeme(Data*)), &w, SLOT(GetSelectedMeme(Data*)));
        QObject::connect( &mw, SIGNAL(selectedBranch(Data*)), &w, SLOT(GetSelectedBranch(Data*)));
        QObject::connect( &mw, SIGNAL(selectedMemeTokugi(Data*) ), &w, SLOT( GetSelectedMemeTokugi(Data*) ) );
        QObject::connect( &mw, SIGNAL(selectedBranchTokugi(Data*) ), &w, SLOT( GetSelectedMemeTokugi(Data*) ) );

        QObject::connect( &cw, SIGNAL(selectedCorona(Data*)), &ptf, SLOT(GetSelectedCorona(Data*)));
        QObject::connect( &mw, SIGNAL(selectedMeme(Data*)), &ptf, SLOT(GetSelectedMeme(Data*)));
        QObject::connect( &mw, SIGNAL(selectedBranch(Data*)), &ptf, SLOT(GetSelectedBranch(Data*)));

        QObject::connect( &ptf, SIGNAL(selectedTokugi(Data*)), &w, SLOT(GetSelectedCoronaTokugi(Data*)));

        QObject::connect( &w, SIGNAL(removeCorona(Data*)), &ptf, SLOT(getRemovedCategory(Data*)));
        QObject::connect( &w, SIGNAL(removeMeme(Data*)), &ptf, SLOT(getRemovedCategory(Data*)));
        QObject::connect( &w, SIGNAL(removeBranch(Data*)), &ptf, SLOT(getRemovedCategory(Data*)));

        QObject::connect( &w, SIGNAL(removeMeme(Data*)), &sf, SLOT(getRemovedCategory(Data*)));
        QObject::connect( &w, SIGNAL(removeBranch(Data*)), &sf, SLOT(getRemovedCategory(Data*)));

        QObject::connect( &cw, SIGNAL(selectedCorona(Data*)), &sf, SLOT(GetSelectedCorona(Data*)));
        QObject::connect( &mw, SIGNAL(selectedMeme(Data*)), &sf, SLOT(GetSelectedMeme(Data*)));
        QObject::connect( &mw, SIGNAL(selectedBranch(Data*)), &sf, SLOT(GetSelectedBranch(Data*)));

        QObject::connect( &sf, SIGNAL(getSlotSoubi(int, Data*)), &w, SLOT(getSlotSoubi(int, Data*)));
        QObject::connect( &sf, SIGNAL(getGeneralSoubi(int, Data*)), &w, SLOT(getGeneralSoubi(int, Data*)));

        QObject::connect( &sf, SIGNAL(removeSlotSoubi(int)), &w, SLOT(removeSelectedSlotSoubi(int)));
        QObject::connect( &w, SIGNAL(removeSlotSoubi(int)), &sf, SLOT(removeSelectedSlotSoubi(int)));
        QObject::connect( &sf, SIGNAL(removeGeneralSoubi(int)), &w, SLOT(removeSelectedGeneralSoubi(int)));
        QObject::connect( &w, SIGNAL(removeGeneralSoubi(int)), &sf, SLOT(removeSelectedGeneralSoubi(int)));

        QObject::connect( &w, SIGNAL(applicationExit()), &a, SLOT(quit()) );

        for(unsigned short i=0;i<slotVector->size();++i)
        {
            QObject::connect( slotVector->at(i)->getPartSoubiTableWidget(), SIGNAL(cellClicked(int,int)), &sf, SLOT(partSoubiTableWidget_cellClicked()));
        }

        return a.exec();
    }
    catch(QString str)
    {
        QMessageBox msgBox;
        msgBox.critical(NULL, QObject::tr("Critical"), str);
        return 0;
    }
}
