#include "mainwindow.h"
#include "ui_mainwindow.h"
#include <QDebug>
#include <QMessageBox>
#include <QFile>
#include <QFileDialog>
#include <QDir>
#include <cmath>
#include <QStringList>

MainWindow::MainWindow(QWidget *parent) :
        QMainWindow(parent),
        ui(new Ui::MainWindow),
        _ownGeneral(NULL),
        _ownCorona(),
        _ownMeme(),
        _ownBranch(),
        _ownTokugiList(),
        _mainMeme(NULL),
        _mainBranch(NULL),
        //この辺
        //どうしたもんか
        //両手のような複数ヶ所同時装備
        //片手のような複数ヶ所複数装備
        //その他のような複数代表文字
        _slotKinds(tr("片;両;胴;乗;他")),
        _ownSoubiList(),
        _slotsVector()
{
    ui->setupUi(this);
    ui->tableWidget->horizontalHeader()->setResizeMode(QHeaderView::ResizeToContents);
    ui->tableWidget_2->horizontalHeader()->setResizeMode(QHeaderView::ResizeToContents);
    ui->tableWidget_3->horizontalHeader()->setResizeMode(QHeaderView::ResizeToContents);
    ui->tableWidget_4->horizontalHeader()->setResizeMode(QHeaderView::ResizeToContents);

    _aif = new ApplicationnInformaitonForm;
    _aif->setWindowTitle("バージョン情報");
    connect(_aif, SIGNAL(hideForm()), this, SLOT(hideApplicationInformationForm()) );
 }

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

bool MainWindow::setGeneral(Data *general)
{
    _general = general;
    return true;
}

bool MainWindow::setCoronaWindow(CoronaWindow* cw)
{
    _cw = cw;
    return true;
}

bool MainWindow::setMemeWindow(MemeWindow* mw)
{
    _mw = mw;
    return true;
}

bool MainWindow::setPossibleTokugiForm(PossibleTokugiForm *ptf)
{
    _ptf = ptf;
    return true;
}

bool MainWindow::setSoubiForm(SoubiForm *sf)
{
    _sf = sf;
    return true;
}

/**
  キャラクターデータ出力
  */
void MainWindow::on_action_triggered()
{
    QDir dir(QDir::current());
    dir.mkdir("CharaData");
    QString fileName = QFileDialog::getSaveFileName(this,
        tr("Write File"), "CharaData", tr("text Files (*.txt)"));
    QFile data(fileName);
    if (data.open(QFile::WriteOnly | QFile::Truncate))
    {
	QTextStream out(&data);

        out << tr("■基本データ\r\n");
        out << tr("【コロナ】");
        QList<Data*> coronaList = GetOwnCoronaList();
	for(int i=0;i<coronaList.size();++i)
	{
	    if(i>0)
	    {
                out << tr("／");
	    }
	    out << coronaList.at(i)->GetName();
	}
        out << tr("\r\n");
        out << tr("【ミーム】");
        QList<Data*> memeList = GetOwnMemeList();
	for(int i=0;i<memeList.size();++i)
	{
	    if(i>0)
	    {
                 out << tr("／");
	    }
	    out << memeList.at(i)->GetName();
	}
        out << tr("\r\n");
        out << tr("【ブランチ】");
        QList<Data*> branchList = GetOwnBranchList();
	for(int i=0;i<branchList.size();++i)
	{
	    if(i>0)
	    {
                 out << tr("／");
	    }
	    out << branchList.at(i)->GetName();
	}
        out << tr("\r\n");

        out << tr("【消費経験点】　0（能力値：0　特技：0　装備：0　パスの追加：0　ブランチの追加：0）\r\n");

	Data* corona = NULL;
        if(GetOwnCoronaList()!=QList<Data*>())
	{
            corona = GetOwnCoronaList().at(0);
	}
        Data* meme = GetMainMeme();
        Data* branch = GetMainBranch();
	QVector<int> kihon(5,0);
	QVector<int> sentou(5,0);

	if( (corona!=NULL) && (meme!=NULL) && (branch!=NULL) )
	{
	    for(int i=0;i<5;++i)
	    {
		kihon.replace(i, corona->GetKihonCapability(i) + meme->GetKihonCapability(i) );
		sentou.replace(i, corona->GetSentouCapability(i) + branch->GetSentouCapability(i) );
	    }
	}

        out << tr("\r\n");
        out << tr("■能力値／耐久力\r\n");
        out << tr("【能力値】　　　　");
        out << tr("肉体") << kihon.at(0) << tr("　　");
        out << tr("技術") << kihon.at(1) << tr("　　");
        out << tr("魔術") << kihon.at(2) << tr("　　");
        out << tr("社会") << kihon.at(3) << tr("　　");
        out << tr("根源") << kihon.at(4) << "\r\n";
        out << tr("【戦闘値元値】　　");
        out << tr("白兵") << sentou.at(0) << tr("　　");
        out << tr("射撃") << sentou.at(1) << tr("　　");
        out << tr("回避") << sentou.at(2) << tr("　　");
        out << tr("心魂") << sentou.at(3) << tr("　　");
        out << tr("行動") << sentou.at(4) << tr("\r\n");
        out << tr("【戦闘値修正値】　");
        out << tr("白兵") << sentou.at(0) << tr("　　");
        out << tr("射撃") << sentou.at(1) << tr("　　");
        out << tr("回避") << sentou.at(2) << tr("　　");
        out << tr("心魂") << sentou.at(3) << tr("　　");
        out << tr("行動") << sentou.at(4) << tr("\r\n");

        out << tr("【ＨＰ】　　　　　元値：") << kihon.at(1) + kihon.at(2) + kihon.at(3) << tr("　　修正値：") << kihon.at(1) + kihon.at(2) + kihon.at(3) << "\r\n";
        out << tr("【ＬＰ】　　　　　元値：") << ceil( (kihon.at(0) + kihon.at(4) )/2.0 ) << tr("　　修正値：") << (kihon.at(0) + kihon.at(4) )/2 <<"\r\n";

        out << tr("\r\n");
        out << tr("■宿命／特徴／闘争／邂逅\r\n");
        out << tr("宿命：　　　特徴：　　　特徴効果：\r\n");
        out << tr("闘争：　　　邂逅：\r\n");

        out << tr("\r\n");
        out << tr("■初期パス\r\n");
        out << tr("【因縁】からの\r\n");

        out << ("\r\n");
        out << tr("■準備された装備\r\n");

        out << tr("部位：名称（必要能力／行動修正／ダメージ／HP修正／射程／備考／参照P）\r\n");

        short  maxLength = 0;
        //かなカナ漢字は一文字3バイト
        for(unsigned short i=0;i<_slotsVector->size();++i)
        {
            maxLength = (maxLength < _slotsVector->at(i)->getPartName().toUtf8().count()) ? (_slotsVector->at(i)->getPartName().toUtf8().count()) : (maxLength);
        }
        for(short i=0;i<_slotsVector->size();++i)
        {
            //スロット名出力
            out << _slotsVector->at(i)->getPartName();
            for(short j=0;_slotsVector->at(i)->getPartName().toAscii().count()+j*3<maxLength;++j)
            {
                out << tr("　");
            }
            out << tr("：");

            //スロットの装備データ出力
            Data *soubi = _slotsVector->at(i)->getSlotSoubi();
            if(soubi!=NULL)
            {
                out << soubi->GetName();
                for(short j=0;soubi->GetName().toUtf8().count()+ j*3 < 45;++j)
                {
                    out << tr("　");
                }
                out << tr("（必：") << soubi->GetCapability();
                out << tr("／行：") << soubi->GetKoudou();
                out << tr("／ダ：") << soubi->GetDamage();
                out << tr("／HP：") << soubi->GetHP();
                out << tr("／射：") << soubi->GetRange();
                out << tr("／") << soubi->GetDetail();
                out << tr("／") << soubi->GetReference();
                out << tr("）");
            }
            else
            {
                out << tr("　　　　　　　　　　　　　　　（必：―／行：―／ダ：―／HP：―／射：―／―／―）");
            }
            out << tr("\r\n");
        }

        out << tr("\r\n");
        out << tr("■コロナ特技\r\n");
	foreach(Data* corona, coronaList)
	{
	    out << GetWritenTokugi(corona);
	}

        out << tr("\r\n");
        out << tr("■ミーム特技\r\n");
	foreach(Data* meme, memeList)
	{
	    out << GetWritenTokugi(meme);
	    for(int i=0;meme->GetOwnChild(i)!=NULL;++i)
	    {
		if(meme->GetOwnChild(i)->GetCategory()!=NULL)
		{
		    out << GetWritenTokugi(meme->GetOwnChild(i));
		}
	    }
	}
	out << GetWritenTokugi(_general);

        out << tr("\r\n");
        out << tr("■装備\r\n");
        Data *soubi;
        for(unsigned short i=0;i<_slotsVector->size();++i)
        {
            soubi = _slotsVector->at(i)->getSlotSoubi();
            if(soubi==NULL)
            {
                continue;
            }
            out << tr("[") << soubi->GetReference() << tr("]");
            out << soubi->GetName();
            out << tr("（部：") << soubi->GetPart() << tr("／");
            out << tr("射：") << soubi->GetRange() << tr("／");
            out << soubi->GetDetail();
            out << tr("）");
            out << tr("\r\n");
        }
        for(unsigned short i=0;i<_ownSoubiList.size();++i)
        {
            soubi = _ownSoubiList.at(i);
            out << tr("[") << soubi->GetReference() << tr("]");
            out << soubi->GetName();
            out << tr("（部：") << soubi->GetPart() << tr("／");
            out << tr("射：") << soubi->GetRange() << tr("／");
            out << soubi->GetDetail();
            out << tr("）");
            out << tr("\r\n");

        }

        out << tr("\r\n");
        out << tr("■属性防御\r\n");
        out << tr("肉体：×　技術：×　魔術：×　社会：×\r\n");

        out << tr("\r\n");
        out << tr("■戦術、設定、メモなど\r\n\r\n");

        QProcess *process = new QProcess;
        process->start("NOTEPAD", QStringList(fileName));
    }
}

QString MainWindow::GetWritenTokugi(Data *parent)
{
    QString lines;
    for(int i=0;parent->GetOwnChild(i)!=NULL;++i)
    {
	Data* tokugi = parent->GetOwnChild(i);
        if(tokugi->GetTokugi()==NULL)
	{
	    continue;
	}
	QVector<QString> property = tokugi->GetProperty();
        lines.append(tr("【") );
	for(int j=1;j<6;++j)
	{
            lines.append(property.at(j) ).append(tr("／") );
	}
        lines.append(tr("】") );
	lines.append(property.at(0) );
	if(tokugi->GetInitialLevel() + tokugi->GetExperimentalLevel() > 1)
	{
	    lines.append(QString::number(tokugi->GetInitialLevel() + tokugi->GetExperimentalLevel() ) );
	}
        lines.append("\r\n");
        lines.append(tr("　")).append(property.at(6) ).append("\r\n");
    }
    return lines;
}

/**
  * 入力：テーブルウィジェット、追加したいデータ、カテゴリ
  *　結果：テーブルウィジェットの表示にカテゴリ追加
  */
bool MainWindow::addCategory(QTableWidget *qtw, Data *data)
{
    // 一番左上が空白なら
    if(qtw->item(0,0)==NULL)
    {
        // 行を一つに
        qtw->setRowCount(1);
    }
    // そうでないなら
    else
    {
        // 行を一つ増やす
        qtw->setRowCount(qtw->rowCount() + 1);
    }

    QTableWidgetItem* item = new QTableWidgetItem(data->GetName(), 0);
    qtw->setItem(qtw->rowCount()-1,0,item);

    int column_num = 1;

    if(data->GetKihonCapability() != QVector<int>())
    {
        for(int j=0;j<5;j++)
        {
            //基本能力の表示
            qtw->setItem(qtw->rowCount()-1,column_num,new QTableWidgetItem(QString::number(data->GetKihonCapability(j)), 0));
            column_num++;
        }
    }
    if(data->GetSentouCapability() != QVector<int>())
    {
        for(int j=0;j<5;j++)
        {
            //戦闘能力の表示
            qtw->setItem(qtw->rowCount()-1,column_num,new QTableWidgetItem(QString::number(data->GetSentouCapability(j)), 0));
            column_num++;
        }
    }
    return true;
}

/**
  * 入力：テーブルウィジェット、除去したいデータの属するリスト、リスト中の除去したいデータの指標
  *　結果：テーブルウィジェットの表示から選択カテゴリ除去
  */
bool MainWindow::removeCategory(QTableWidget *qtw, QList<Data*> list, int num)
{
    Data* data = list.at(num);
    if(data==NULL) // data が null のエラー回避
    {
        QMessageBox::warning(ui->tableWidget, "Warning", tr("データがありません") ,QMessageBox::Ok,QMessageBox::NoButton);
        return false;
    }
    // 所属特技除去
    removeAllTokugiIn(data);

    //所属分類・装備除去
    removeAllSoubiIn(data);

    list.removeAt(num);

    qtw->removeRow(qtw->currentRow());

    // 行が無くなったなら
    if(qtw->rowCount()==0)
    {
        // 行を一つ増やす
        qtw->setRowCount(1);
    }

    return true;
}

/**
  * 入力：所属、追加したい特技データ
  *　結果：テーブルウィジェットの表示にカテゴリ追加
  */
bool MainWindow::addTokugi(Data *tokugi)
{
    try
    {
        if(tokugi == NULL) // tokugi が null のエラー回避
        {
            throw tr("特技がありません");
        }

        Data* parent = tokugi->GetParent();
        // 特技なら
        if( (parent == NULL) )// parent が null のエラー回避
        {
            throw tr("特技が属しているものがありません");
        }

        //所属元を取得していないならば
        if( (parent->IsOwned()==false) && (parent != _ownGeneral) )
        {
            throw tr("特技が属しているものが取得されていません");
        }

        // 所属列検索
        int baseColumn = -1;
        for(int k=0;k<ui->tableWidget_2->columnCount();++k)
        {
            if( ui->tableWidget_2->horizontalHeaderItem(k)->text().contains(tr("所属")) )
            {
                baseColumn = k;
                break;
            }
        }
        if(baseColumn==-1)
        {
            throw tr("所属列が見つかりません");
        }

        // 特技名列検索
        int nameColumn = -1;
        for(int k=0;k<ui->tableWidget_2->columnCount();++k)
        {
            if( ui->tableWidget_2->horizontalHeaderItem(k)->text().contains(tr("特技名")) )
            {
                nameColumn = k;
                break;
            }
        }
        if(nameColumn==-1)
        {
            throw tr("特技名列が見つかりません");
        }

        // 初めて取得した特技の場合
        if(!tokugi->IsOwned())
        {
            _ownTokugiList.append(tokugi);
            parent->OwnAdd(tokugi);
            tokugi->IncreaseInitialLevel();
            // 一番左上が空白なら
            if(ui->tableWidget_2->item(0,0)==NULL)
            {
                // 行を一つに
                ui->tableWidget_2->setRowCount(1);
            }
            // そうでないなら
            else
            {
                // 行を一つ増やす
                ui->tableWidget_2->setRowCount(ui->tableWidget_2->rowCount() + 1);
            }

            // 所属の表示 順番の柔軟性を持たせたいのだが
            ui->tableWidget_2->setItem(ui->tableWidget_2->rowCount()-1, baseColumn, new QTableWidgetItem(tokugi->GetParent()->GetName(),0) );

            QVector<QString> property = tokugi->GetProperty();

            // 特技のレベル"1"を表示
            QString q = property.at(0);
            q.append("[1/1]");
            ui->tableWidget_2->setItem(ui->tableWidget_2->rowCount()-1 , nameColumn, new QTableWidgetItem(q, 0) );
            for(int j=1;j<property.size();++j)
            {
                ui->tableWidget_2->setItem(ui->tableWidget_2->rowCount()-1 ,j+1, new QTableWidgetItem(property.at(j), 0));
            }
            ui->tableWidget_2->resizeColumnsToContents();


            //装備分類取得
            /*
        foreach(Data *grouping, tokugi->GetChildGrouping())
        {
            tokugi->OwnAdd(grouping);
        }
        */
            ownAddGrouping(tokugi);
        }
        // 既に取得している特技のレベルを上げる場合
        else
        {
            //初期特技点分のレベルアップ
            tokugi->IncreaseInitialLevel();

            /*
                //経験点分のレベルアップ
                otokugi->IncreaseExperimentalLevel();
                */
            QString tokugiName = tokugi->GetName();
            tokugiName.append("\\[(\\d)+/(\\d)+\\]");
            QList<QTableWidgetItem*> q = ui->tableWidget_2->findItems(tokugiName, Qt::MatchRegExp);

            int row = q.at(0)->row();
            QString initialLevel = QString::number( tokugi->GetInitialLevel() );
            QString totalLevel = QString::number( tokugi->GetInitialLevel() + tokugi->GetExperimentalLevel() );
            ui->tableWidget_2->setItem(row, nameColumn, new QTableWidgetItem(tokugi->GetName().append("[").append(initialLevel).append("/").append(totalLevel).append("]"), 0 ) );
        }
        return true;
    }
    catch(QString str)
    {
        QMessageBox::warning(ui->tableWidget, tr("Warning"), str, QMessageBox::Ok, QMessageBox::NoButton);
        return false;
    }
}

/**
  所属特技を取得特技欄から除去
  入力：親データ
  内容：親データ直下の特技を取消
  */
bool MainWindow::removeAllTokugiIn(Data *parent)
{
    for(int i=0;i<_ownTokugiList.size();)
    {
        if(_ownTokugiList.at(i)->GetParent() == parent)
        {
            while(_ownTokugiList.at(i)->GetInitialLevel()>0)
            {
                _ownTokugiList.at(i)->DecreaseInitialLevel();
            }
            _ownTokugiList.removeAt(i);
            ui->tableWidget_2->removeRow(i);
        }
        else
        {
            ++i;
        }
    }

    // 行が無くなったなら
    if(ui->tableWidget_2->rowCount()==0)
    {
        // 行を一つ増やす
        ui->tableWidget_2->setRowCount(1);
    }
    return true;
}

/**
  _ownGeneralの設定
  */
bool MainWindow::setOwnGeneral(Data *ownGeneral)
{
    _ownGeneral = ownGeneral;
    return true;
}

/**
 自動取得特技
 input : OwnData*(取得特技所属データ)
 ToDo 初期特技点や経験点の計算
*/
bool MainWindow::getAutoGottenTokugi(Data* ownParent)
{
    foreach(Data *tokugi, ownParent->getAutoGetTokugiList() )
    {
        addTokugi(tokugi);
    }

return true;
}

/**
  * 入力：所属ウィジェット、取得したい装備のスロット中の指標、装備データ
  */
bool MainWindow::addSoubi(QTableWidget *w, unsigned short i, Data *soubi)
{
    try
    {
        // 所属列検索
        int baseColumn = -1;
        for(int k=0;k<ui->SoubiSlotTableWidget->columnCount();++k)
        {
            if( ui->SoubiSlotTableWidget->horizontalHeaderItem(k)->text().contains(tr("装備箇所")) )
            {
                baseColumn = k;
                break;
            }
        }
        if(baseColumn==-1)
        {
            throw tr("分類列が見つかりません");
        }

        // 装備名列検索
        int nameColumn = -1;
        for(int k=0;k<ui->SoubiSlotTableWidget->columnCount();++k)
        {
            if( ui->SoubiSlotTableWidget->horizontalHeaderItem(k)->text().contains(tr("名称")) )
            {
                nameColumn = k;
                break;
            }
        }
        if(nameColumn==-1)
        {
            throw tr("装備名が見つかりません");
        }

        //一般装備
        if(w == ui->ownSoubiTableWidget)
        {
            _ownSoubiList.append(soubi);
            w->setItem(w->rowCount()-1, 0, new QTableWidgetItem(soubi->GetParent()->GetName()));
            // 行を一つ増やす
            w->setRowCount(w->rowCount() +1);
        }

        unsigned short row = i;
        // 分類の表示 順番の柔軟性を持たせたいのだが
        //w->setItem(row, baseColumn, new QTableWidgetItem(soubi->GetParent()->GetName(),0) );

        // 装備名の表示
        QVector<QString> property = soubi->GetProperty();
        w->setItem(row, nameColumn, new QTableWidgetItem(property.at(0), 0) );

        //その他のものの表示
        for(int j=1;j<property.size();++j)
        {
            w->setItem(row, j+1, new QTableWidgetItem(property.at(j), 0));
        }
        w->resizeColumnsToContents();

        // 初めて取得した装備の場合
        if(!soubi->IsOwned())
        {
            soubi->GetParent()->OwnAdd(soubi);
        }
        //経験点分のレベルアップ
        //otokugi->IncreaseExperimentalLevel();

        return true;
    }
    catch(QString str)
    {
        QMessageBox::warning(ui->SoubiSlotTableWidget, tr("Warning"), str, QMessageBox::Ok, QMessageBox::NoButton);
        return false;
    }
}

/**
  入力：装備に関するテーブルウィジェット
  内容：テーブルウィジェットから選択装備の除去と一般装備リストから除去
  */
bool MainWindow::removeSoubiFromWidget(QTableWidget *w, unsigned short i)
{
    try
    {
        int row = i;
        if(row<0)
        {
            throw tr("装備を選択してください");
        }

        //装備スロットの場合
        if(w == ui->SoubiSlotTableWidget)
        {
            for(unsigned short column=1;column<12;++column)
            {
                w->takeItem(row, column);
            }
        }
        //一般装備に入っている場合
        else if(w == ui->ownSoubiTableWidget)
        {
            _ownSoubiList.removeAt(i);
            w->removeRow(row);
        }

        // 行が無くなったなら
        if(w->rowCount()==0)
        {
            // 行を一つ増やす
            w->setRowCount(1);
        }
        return true;
    }
    catch(QString str)
    {
        QMessageBox::warning(w, tr("Warning"), str, QMessageBox::Ok, QMessageBox::NoButton);
        return false;
    }
}

/**
  所属装備を取得装備欄から除去
  入力：親データ
  内容：親データ直下の装備を取消
  */
bool MainWindow::removeAllSoubiIn(Data *parent)
{
    //装備スロット
    for(unsigned short i=0;i<_slotsVector->size();++i)
    {
        Data *soubi = _slotsVector->at(i)->getSlotSoubi();
        if(soubi == NULL)
        {
            continue;
        }
        if(soubi->GetParent()->GetParent() == parent)
        {
            soubi->GetParent()->OwnRemove(soubi);
            removeSoubiFromWidget(ui->SoubiSlotTableWidget, i);
           _slotsVector->at(i)->setSoubi(NULL);
           emit removeSlotSoubi(i);
       }
    }
    // 行が無くなったなら
    if(ui->SoubiSlotTableWidget->rowCount()==0)
    {
        // 行を一つ増やす
        ui->SoubiSlotTableWidget->setRowCount(1);
    }

    //一般装備
    //テーブルウィジェットの行を削除していくので順序が乱れぬように下から、つまり逆順
    for(short i=_ownSoubiList.size()-1;i>=0;--i)
    {
        Data *soubi = _ownSoubiList.at(i);
        if(soubi->GetParent()->GetParent() == parent)
        {
            soubi->GetParent()->OwnRemove(soubi);
            removeSoubiFromWidget(ui->ownSoubiTableWidget, i);
            emit removeGeneralSoubi(i);
        }
    }
    // 行が無くなったなら
    if(ui->ownSoubiTableWidget->rowCount()==0)
    {
        // 行を一つ増やす
        ui->ownSoubiTableWidget->setRowCount(1);
    }

    return true;
}

/**
  装備分類を取得
  入力：データ
  出力：なし
  処理：データ直下の装備分類を取得
  */
bool MainWindow::ownAddGrouping(Data *data)
{
    Data *child = NULL;
    for(short i=0;data->GetChild(i)!=NULL;++i)
    {
        child = data->GetChild(i);
        if(child->GetGrouping()==NULL)
        {
            continue;
        }
        data->OwnAdd(child);
    }
    return true;
}

/**
  装備スロットの設定
  */
bool MainWindow::setSoubiSlots(QVector<SoubiSlot *> *slotsVector)
{
    _slotsVector = slotsVector;
    ui->SoubiSlotTableWidget->setRowCount(0);
    for(unsigned short i=0;i<slotsVector->size();++i)
    {
        ui->SoubiSlotTableWidget->setRowCount(ui->SoubiSlotTableWidget->rowCount()+1);
        ui->SoubiSlotTableWidget->setItem(i, 0, new QTableWidgetItem(slotsVector->at(i)->getPartName()));
    }
    return true;
}



//public slots
void MainWindow::hideApplicationInformationForm()
{
    _aif->hide();
}

void MainWindow::GetSelectedCoronaTokugi(Data *tokugi) //slot
{
    addTokugi(tokugi);
}

void MainWindow::GetSelectedMemeTokugi(Data *tokugi) //slot
{
    addTokugi(tokugi);
}

void MainWindow::GetSelectedBranchTokugi(Data *tokugi) //slot
{
    addTokugi(tokugi);
}

/**
  from SoubiForm::on_soubiAddButton_clicked()
  入力：取得したい装備スロットのスロット中の指標、装備データ
  結果：テーブルウィジェットの表示にカテゴリ追加
  */
void MainWindow::getSlotSoubi(int i, Data *soubi) //slot
{
    addSoubi(ui->SoubiSlotTableWidget, i, soubi);
}

/**
  from SoubiForm::on_soubiAddButton_clicked()
  入力：取得したい一般装備の指標、装備データ
  結果：テーブルウィジェットの表示にカテゴリ追加
  */
void MainWindow::getGeneralSoubi(int i, Data *soubi) //slot
{
    addSoubi(ui->ownSoubiTableWidget, i, soubi);
}

/**
  from SoubiForm
  */
void MainWindow::removeSelectedSlotSoubi(int i)
{
    removeSoubiFromWidget(ui->SoubiSlotTableWidget, i);
}

/**
  from SoubiForm
  */
void MainWindow::removeSelectedGeneralSoubi(int i)
{
    removeSoubiFromWidget(ui->ownSoubiTableWidget, i);
}

//private slots
void MainWindow::on_action_2_triggered()
{
    _cw->show();
}

void MainWindow::on_action_3_triggered()
{
    _mw->show();
}

void MainWindow::on_action_4_triggered()
{
    _ptf->show();
}

void MainWindow::closeEvent(QCloseEvent *event)
{
    event->accept();
}

void MainWindow::on_applicationInformation_triggered()
{
    _aif->show();
}

void MainWindow::on_applicationExit_triggered()
{
    emit applicationExit();
}

void MainWindow::on_action_soubi_triggered()
{
    _sf->show();
}

/**
from CoronaWindow
コロナ取得
*/
void MainWindow::GetSelectedCorona(Data *selCorona) //slot
{
    // 選択コロナが取得コロナかチェック
    if(selCorona->IsOwned())
    {
        QMessageBox::warning(ui->tableWidget, tr("Warning"), tr("取得済みのコロナです"), QMessageBox::Ok,QMessageBox::NoButton);
        return;
    }

    // 異なっていた場合
    ui->tableWidget->clearContents();

    // 子取得特技を除去のため
    // コロナを取得している　かつ　取得コロナがデータを持っている場合
    if(_ownCorona.size()>0)
    {
        removeAllTokugiIn(_ownCorona.at(0));

        //取得コロナ除去
        emit removeCorona(_ownCorona.at(0));
        removeCategory(ui->tableWidget, _ownCorona, 0);
        _ownGeneral->OwnRemove(_ownCorona.takeFirst());
    }
    // 後に選択コロナを取得
    _ownCorona.append(selCorona);
    _ownGeneral->OwnAdd(selCorona);

    addCategory(ui->tableWidget, selCorona);

    // 自動取得特技
    getAutoGottenTokugi(selCorona);

    //装備分類取得
    /*
    foreach(Data *grouping, selCorona->GetChildGrouping())
    {
        selCorona->OwnAdd(grouping);
    }
    */
    ownAddGrouping(selCorona);
}

/**
from MemeWindow::selectedMeme
ミーム取得
*/
void MainWindow::GetSelectedMeme(Data *selMeme) //slot
{
    if(selMeme == NULL)
    {
        QMessageBox::warning(ui->tableWidget, tr("Warning"), tr("何かミームを選択してください"), QMessageBox::Ok, QMessageBox::NoButton);
        return;
    }

    // 選択ミームが取得ミームかチェック
    if(selMeme->IsOwned())
    {
        QMessageBox::warning(ui->tableWidget, tr("Warning"), tr("取得済みのミームです"),QMessageBox::Ok,QMessageBox::NoButton);
        return;
    }
    // 異なっていた場合
    //ミーム取得
    _ownMeme.append(selMeme);
    _ownGeneral->OwnAdd(selMeme);
    addCategory(ui->tableWidget_3, selMeme);

    ui->comboBox->addItem(selMeme->GetName());

    // 自動取得特技
    // ToDo 初期特技点や経験点の計算
    //getAutoGottenTokugi(selMeme);

    //装備分類取得
    /*
    foreach(Data *grouping, selMeme->GetChildGrouping())
    {
        selMeme->OwnAdd(grouping);
    }
    */
    ownAddGrouping(selMeme);
}

/**
from BranchWindow
ブランチ取得
*/
void MainWindow::GetSelectedBranch(Data *selBranch) //slot
{
    //ブランチ取得
    _ownBranch.append(selBranch);
    selBranch->GetParent()->OwnAdd(selBranch);

    addCategory(ui->tableWidget_4, selBranch);

    if(selBranch->GetParent() == _mainMeme)
    {
        ui->comboBox_2->addItem(selBranch->GetName());
    }

    // 自動取得特技
    getAutoGottenTokugi(selBranch);

    //装備分類取得
    /*
        foreach(Data *grouping, selBranch->GetChildGrouping())
        {
            selBranch->OwnAdd(grouping);
        }
        */
    ownAddGrouping(selBranch);
}

/**
 コロナ取り消しボタン
 */
void MainWindow::on_pushButton_clicked()
{
    if(ui->tableWidget->item(ui->tableWidget->currentRow(), 0)==NULL)
    {
        QMessageBox::warning(ui->tableWidget, tr("Warning"), tr("コロナを選択してください"),QMessageBox::Ok,QMessageBox::NoButton);
        return;
    }

    removeAllTokugiIn(_ownCorona.at(0));

    //取得コロナ除去
    emit removeCorona(_ownCorona.at(0));
    removeCategory(ui->tableWidget, _ownCorona, 0);
    _ownGeneral->OwnRemove(_ownCorona.takeFirst());
}

/**
  ミーム取り消しボタン
  */
void MainWindow::on_pushButton_3_clicked()
{
    int row = ui->tableWidget_3->currentRow();
    if(ui->tableWidget_3->item(row, 0)==NULL)
    {
        QMessageBox::warning(ui->tableWidget_3, tr("Warning"), tr("ミームを選択してください"),QMessageBox::Ok,QMessageBox::NoButton);
        return;
    }

    Data* selMeme = _ownMeme.at(row);
    //選択ミーム下の取得ブランチを欄から除去
    for(int i=0;i<_ownBranch.size();)
    {
        if(_ownBranch.at(i)->GetParent()==selMeme)
        {
            ui->tableWidget_4->removeRow(i);

            emit removeBranch(_ownBranch.at(i));

            removeAllTokugiIn(_ownBranch.takeAt(i));
            continue;
        }
        ++i;
    }

    removeAllTokugiIn(selMeme);
    //選択ミーム除去
    emit removeMeme(selMeme);

    if(selMeme == _mainMeme)
    {
        ui->comboBox->setCurrentIndex(-1);
        ui->comboBox_2->clear();
        _mainMeme = NULL;
        _mainBranch = NULL;
    }
    ui->comboBox->removeItem(row);
    removeCategory(ui->tableWidget_3, _ownMeme, row);
    _ownGeneral->OwnRemove(_ownMeme.takeAt(row));
}

/**
  ブランチ取り消しボタン
  */
void MainWindow::on_pushButton_4_clicked()
{
    int row = ui->tableWidget_4->currentRow();
    if(ui->tableWidget_4->item(row, 0)==NULL)
    {
        QMessageBox::warning(ui->tableWidget_4, tr("Warning"), tr("ブランチを選択してください"),QMessageBox::Ok,QMessageBox::NoButton);
        return;
    }

    Data *selBranch = _ownBranch.at(row);
    removeAllTokugiIn(selBranch);

    //取得ブランチ除去
    if(selBranch->GetParent() == _mainMeme)
    {
        int i = 0;
        foreach(Data *branch, _ownBranch)
        {
            if(branch->GetParent() == _mainMeme)
            {
                if(branch == selBranch)
                {
                    ui->comboBox_2->removeItem(i);
                    break;
                }
                ++i;
            }
        }
    }
    removeBranch(selBranch);
    removeCategory(ui->tableWidget_4, _ownBranch, row);
    selBranch->GetParent()->OwnRemove(_ownBranch.takeAt(row));
}

/**
  特技取消ボタン
  */
void MainWindow::on_pushButton_2_clicked()
{
    int row = ui->tableWidget_2->currentRow();
    if( (row >= _ownTokugiList.size()) || (row < 0) )
    {
        QMessageBox::warning(ui->tableWidget_2, tr("Warning"), tr("特技の選択が不正です"), QMessageBox::Ok, QMessageBox::NoButton);
        return;
    }

    Data* od = _ownTokugiList.at(row);
    if( (od->GetName().contains("◆")) && (od->GetInitialLevel()==1) )
    {
        QMessageBox::warning(ui->tableWidget_2, tr("Warning"), tr("自動取得特技は取り消せません"));
        return;
    }

    od->DecreaseInitialLevel();
    // 取得特技を取り除く場合
    if(od->GetInitialLevel() == 0)
    {
        if(! od->GetParent()->OwnRemove(od) )
        {
            QMessageBox::warning(ui->tableWidget_2, tr("Warning"), tr("特技の取消なんか失敗"),QMessageBox::Ok,QMessageBox::NoButton);
            return;
        }
        _ownTokugiList.removeOne(od);
        ui->tableWidget_2->removeRow(row);

    }
    // 取得特技のレベルを下げる場合
    else
    {
        // 特技名列検索
        int nameColumn = -1;
        for(int k=0;k < ui->tableWidget_2->columnCount();++k)
        {
            if( ui->tableWidget_2->horizontalHeaderItem(k)->text().contains(tr("特技名")) )
            {
                nameColumn = k;
                break;
            }
        }

        if(nameColumn==-1)
        {
            QMessageBox::warning(ui->tableWidget_2, tr("Warning"), tr("特技名列が見つかりません"), QMessageBox::Ok, QMessageBox::NoButton);
            return;
        }
        ui->tableWidget_2->setItem(ui->tableWidget_2->currentRow(), nameColumn, new QTableWidgetItem( od->GetName().append("[").append(QString::number( od->GetInitialLevel()) ).append("/").append(QString::number( od->GetInitialLevel() + od->GetExperimentalLevel()) ).append("]"), 0) );
    }
    //emit removeRowSignal(row);
}

/**
  装備スロット取消ボタン
  */
void MainWindow::on_removeSoubiSlotButton_clicked()
{
    int row = ui->SoubiSlotTableWidget->currentRow();
    if(row<0)
    {
        return;
    }
    Data *soubi = _slotsVector->at(row)->getSlotSoubi();
    if(soubi==NULL)
    {
        return;
    }
    soubi->GetParent()->OwnRemove(soubi);
    removeSoubiFromWidget(ui->SoubiSlotTableWidget, ui->SoubiSlotTableWidget->currentRow());
    _slotsVector->at(ui->SoubiSlotTableWidget->currentRow())->setSoubi(NULL);
    emit removeSlotSoubi(ui->SoubiSlotTableWidget->currentRow());
}

/**
  一般装備取り消しボタン
  */
void MainWindow::on_removeSoubiButton_clicked()
{
    int row = ui->ownSoubiTableWidget->currentRow();
    if(row<0)
    {
        return;
    }
    Data *soubi = _ownSoubiList.at(row);
    if(soubi==NULL)
    {
        return;
    }
    soubi->GetParent()->OwnRemove(soubi);
    removeSoubiFromWidget(ui->ownSoubiTableWidget, row);
    emit removeGeneralSoubi(row);
}

/**
  取得コロナリスト取得
  */
QList<Data*> MainWindow::GetOwnCoronaList()
{
    return _ownCorona;
}

/**
  取得ミームリスト取得
  */
QList<Data*> MainWindow::GetOwnMemeList()
{
    return _ownMeme;
}

/**
  取得ブランチリスト取得
  */
QList<Data*> MainWindow::GetOwnBranchList()
{
    return _ownBranch;
}

/**
  取得特技リスト取得
  */
QList<Data*> MainWindow::GetOwnTokugiList()
{
    return _ownTokugiList;
}

/**
  メインミームセット
  */
Data* MainWindow::GetMainMeme()
{
    return _mainMeme;
}

/**
  メインブランチセット
  */
Data* MainWindow::GetMainBranch()
{
    return _mainBranch;
}

/**
  メインミーム選択コンボボックスでの選択
  */
void MainWindow::on_comboBox_currentIndexChanged(int index)
{
    if( (ui->comboBox->count() == 0) || (index < 0) )
    {
        return;
    }

    _mainMeme = _ownMeme.at(index);

    ui->comboBox_2->clear();
    if(_ownBranch.size()>0)
    {
        foreach(Data *b, _ownBranch)
        {
            if(b->GetParent() == _mainMeme)
            {
                ui->comboBox_2->addItem(b->GetName());
            }
        }
    }
}

/**
  メインブランチ選択コンボボックスでの選択
  */
void MainWindow::on_comboBox_2_currentIndexChanged(int index)
{
    if(ui->comboBox_2->count()==0)
    {
        return;
    }
    _mainBranch = _ownBranch.at(index);
}
/**
  リサイズイベント
  列リサイズ
  */
void MainWindow::resizeEvent(QResizeEvent *)
{
    ui->tableWidget_2->resizeColumnsToContents();
}

/**
  特技欄セルクリック
  列リサイズ
  */
void MainWindow::on_tableWidget_2_cellClicked(int row, int column)
{
    ui->tableWidget_2->resizeColumnToContents(column);
}

void MainWindow::on_tableWidget_clicked(QModelIndex index)
{
    ui->tableWidget->resizeColumnsToContents();
}

void MainWindow::on_tableWidget_3_clicked(QModelIndex index)
{
    ui->tableWidget_3->resizeColumnsToContents();
}

void MainWindow::on_tableWidget_4_clicked(QModelIndex index)
{
    ui->tableWidget_4->resizeColumnsToContents();
}

void MainWindow::on_tableWidget_2_clicked(QModelIndex index)
{
    ui->tableWidget_2->resizeColumnsToContents();
}
