#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QCloseEvent>
#include <QTableWidget>
#include <QProcess>
#include "data.h"
#include "corona.h"
#include "meme.h"
#include "branch.h"
#include "tokugi.h"
#include "soubi.h"
#include "coronawindow.h"
#include "memewindow.h"
#include "possibletokugiform.h"
#include "soubiform.h"
#include "soubislot.h"
#include "applicationninformaitonform.h"

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow {
    Q_OBJECT
public:
    MainWindow(QWidget *parent = 0);
    virtual ~MainWindow();
    virtual bool setGeneral(Data* general);
    virtual bool setCoronaWindow(CoronaWindow*);
    virtual bool setMemeWindow(MemeWindow*);
    virtual bool setPossibleTokugiForm(PossibleTokugiForm*);
    virtual bool setSoubiForm(SoubiForm *sf);
    virtual QString GetWritenTokugi(Data* parent);

    bool addCategory(QTableWidget*, Data*);
    bool removeCategory(QTableWidget* qtw, QList<Data*> list, int num);
    bool addTokugi(Data* tokugi);
    bool removeAllTokugiIn(Data* parent);
    bool setOwnGeneral(Data* ownGeneral);
    bool getAutoGottenTokugi(Data* ownParent);

    bool addSoubi(QTableWidget *w, unsigned short i, Data *soubi);
    bool removeSoubiFromWidget(QTableWidget *w, unsigned short i);
    bool removeAllSoubiIn(Data *parent);
    bool ownAddGrouping(Data *data);
    bool setSoubiSlots(QVector<SoubiSlot*> *slotsVector);

    QList<Data*> GetOwnCoronaList();
    QList<Data*> GetOwnMemeList();
    QList<Data*> GetOwnBranchList();
    QList<Data*> GetOwnTokugiList();
    Data* GetMainMeme();
    Data* GetMainBranch();

protected:
    void changeEvent(QEvent *e);
    void closeEvent(QCloseEvent *event);

private:
    Ui::MainWindow *ui;
    Data* _general;
    CoronaWindow* _cw;
    MemeWindow* _mw;
    PossibleTokugiForm* _ptf;
    SoubiForm *_sf;
    ApplicationnInformaitonForm *_aif;

    Data* _ownGeneral;
    QList<Data*> _ownCorona;
    QList<Data*> _ownMeme;
    QList<Data*> _ownBranch;
    QList<Data*> _ownTokugiList;
    Data* _mainMeme;
    Data* _mainBranch;
    QString _slotKinds;
    QList<Data*> _ownSoubiList;
    QVector<SoubiSlot*> *_slotsVector;

signals:
    void checkOwn();
    void applicationExit();
    void removeCorona(Data*);
    void removeMeme(Data*);
    void removeBranch(Data*);
    void removeSlotSoubi(int);
    void removeGeneralSoubi(int);

public slots:
    void hideApplicationInformationForm();

    //from CoronaWindow
    void GetSelectedCorona(Data *corona);
    void GetSelectedCoronaTokugi(Data* tokugi);

    //from MemeWindow
    void GetSelectedMeme(Data*meme);
    void GetSelectedBranch(Data*branch);
    void GetSelectedMemeTokugi(Data* tokugi);
    void GetSelectedBranchTokugi(Data* tokugi);

    //from SoubiForm
    void getSlotSoubi(int i, Data *soubi);
    void getGeneralSoubi(int i, Data *soubi);
    void removeSelectedSlotSoubi(int i);
    void removeSelectedGeneralSoubi(int i);

private slots:
    void on_tableWidget_clicked(QModelIndex index);
    void on_tableWidget_2_clicked(QModelIndex index);
    void on_tableWidget_3_clicked(QModelIndex index);
    void on_tableWidget_4_clicked(QModelIndex index);
    void on_action_soubi_triggered();
    void on_applicationExit_triggered();
    void on_action_triggered(); //キャラクタデータ出力
    void on_action_2_triggered();
    void on_action_3_triggered();
    void on_action_4_triggered();
    void on_applicationInformation_triggered(); //バージョン情報ウィンドウ表示

    //リサイズ
    void resizeEvent(QResizeEvent *);
    //特技テーブルウィジェットのセルクリック
    void on_tableWidget_2_cellClicked(int row, int column);
    //メインミーム変更時
    void on_comboBox_currentIndexChanged(int index);
    //メインブランチ変更時
    void on_comboBox_2_currentIndexChanged(int index);
    //コロナ取消
    void on_pushButton_clicked();
    //特技取消
    void on_pushButton_2_clicked();
    //ミーム取消
    void on_pushButton_3_clicked();
    //ブランチ取消
    void on_pushButton_4_clicked();
    //装備スロット取消
    void on_removeSoubiSlotButton_clicked();
    //一般装備取消
    void on_removeSoubiButton_clicked();
};

#endif // MAINWINDOW_H
