#include "memewindow.h"
#include "ui_memewindow.h"
#include <QDebug>
#include <QMessageBox>
#include "meme.h"
#include "branch.h"

MemeWindow::MemeWindow(CategoryWindow *parent) :
    CategoryWindow(parent),
    ui(new Ui::MemeWindow),
    _memeList(),
    _memeTokugiTableWidget(ui->tokugiTableWidget),
    _branchList(),
    _branchTokugiTableWidget(ui->tokugiTableWidget)
{
    ui->setupUi(this);
    _memeTokugiTableWidget = ui->tokugiTableWidget;
    _branchTokugiTableWidget = ui->tokugiTableWidget;
    setTableResize();
}

MemeWindow::~MemeWindow()
{
    delete ui;
}

void MemeWindow::changeEvent(QEvent *e)
{
    QWidget::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void MemeWindow::resizeEvent(QResizeEvent *)
{
    //ui->MemeTokugiTableWidget->resizeColumnsToContents();
    //ui->BranchTokugiTableWidget->resizeColumnsToContents();
    ui->tokugiTableWidget->resizeColumnsToContents();
}

/**
  ミーム欄に選択されたdata以下の子ミームを表示、特技テーブルウィジェットの挿入
  初期化処理
  */
bool MemeWindow::addMeme(Data * data)
{
    bool b = addCategory(ui->MemeTableWidget, data, _memeList, new Meme);

    //ミーム
    foreach(Data *m, _memeList)
    {
        ui->tokugiVerticalLayout->insertWidget(ui->tokugiVerticalLayout->count() -1, m->getTokugiTableWidget());
        //ui->memeVerticalLayout->insertWidget(ui->verticalLayout_2->count() -1, m->getTokugiTableWidget() );
        m->getTokugiTableWidget()->hide();

        //ブランチ
        for(int i=0;m->GetChild(i)!=NULL;++i)
        {
            Data *branch = m->GetChild(i);
            if(branch->GetCategory()!=NULL)
            {
                ui->tokugiVerticalLayout->insertWidget(ui->tokugiVerticalLayout->count() -1, branch->getTokugiTableWidget());
                //ui->branchVerticalLayout->insertWidget(ui->verticalLayout_3->count() -1, branch->getTokugiTableWidget() );
                branch->getTokugiTableWidget()->hide();
            }
        }
    }

    return b;
}

bool MemeWindow::setTableResize()
{
    ui->MemeTableWidget->horizontalHeader()->setResizeMode(QHeaderView::ResizeToContents);
    //ui->MemeTokugiTableWidget->horizontalHeader()->setResizeMode(QHeaderView::ResizeToContents);
    ui->BranchTableWidget->horizontalHeader()->setResizeMode(QHeaderView::ResizeToContents);
    //ui->BranchTokugiTableWidget->horizontalHeader()->setResizeMode(QHeaderView::ResizeToContents);
    ui->tokugiTableWidget->horizontalHeader()->setResizeMode(QHeaderView::ResizeToContents);
    return true;
}

/**
  クリックされたミーム以下の特技をミーム特技欄に表示
  また、ブランチ欄にそのミーム以下のブランチを表示
  */
void MemeWindow::on_MemeTableWidget_clicked(QModelIndex index)
{
    setSelectedCategory(_memeList.at(ui->MemeTableWidget->currentRow()));

    ui->tokugiTableWidget->hide();
    _branchList.clear();
    _branchTokugiTableWidget->hide();
    //_branchTokugiTableWidget = ui->BranchTokugiTableWidget;
    //_branchTokugiTableWidget->show();

    //一回一回テーブルウィジェットを生成してしまうのはやめたい
    addCategory(ui->BranchTableWidget, _memeList.at(ui->MemeTableWidget->currentRow()), _branchList, new Branch);

    _memeTokugiTableWidget->hide();
    _memeTokugiTableWidget = showTokugiTableWidget(_memeList.at(ui->MemeTableWidget->currentRow()) );

    //リサイズ
    ui->MemeTableWidget->resizeColumnsToContents();
}

/**
  クリックされたブランチ以下の特技をブランチ特技欄に表示
  */
void MemeWindow::on_BranchTableWidget_clicked(QModelIndex index)
{
    setSelectedCategory(_branchList.at(ui->BranchTableWidget->currentRow()));

    _memeTokugiTableWidget->hide();
    _branchTokugiTableWidget->hide();
    _branchTokugiTableWidget = showTokugiTableWidget(_branchList.at(ui->BranchTableWidget->currentRow()) );
    _branchTokugiTableWidget->show();

    //リサイズ
    ui->BranchTableWidget->resizeColumnsToContents();
}

/**
  * ミーム取得ボタン
  * 取得ミームを設定
  */
void MemeWindow::on_GetMemeButton_clicked()
{
    Data* selMeme = _memeList.at(ui->MemeTableWidget->currentRow());

    //to MainWindow::GetSelectedMeme
    //for displaying corona
    emit selectedMeme(selMeme);
    return;
}

/**
  * ブランチ取得ボタン
  * 取得ブランチを設定
  */
void MemeWindow::on_GetBranchButton_clicked()
{
    try
    {
        Data* selBranch = getSelectedCategory(); //_branchList.at(ui->BranchTableWidget->currentRow());

        if(selBranch == NULL)
        {
            throw tr("何かブランチを選択してください");
        }
        //_ownMeme = OwnMeme::GetInstance();

        // 選択ブランチが取得ブランチかチェック
        if(selBranch->IsOwned())
        {
            throw tr("取得済みのブランチです");
        }

        // 取得していない場合
        //選択ブランチのミームを取得しているかチェック
        if(!selBranch->GetParent()->IsOwned())
        {

            //取得していない場合
            int ret = QMessageBox::question(this, tr("Question"), tr("このブランチの属するミームを取得していません\r\nついでに取得しますか？"), QMessageBox::Ok | QMessageBox::Cancel,QMessageBox::NoButton);
            switch(ret)
            {
            case QMessageBox::Ok:
                {
                    //ミーム取得
                    selectedMeme(selBranch->GetParent());
                    break;
                }
            case QMessageBox::Cancel:
                return;
                break;
            default:
                return;
                break;
            }
        }

        //to MainWindow::GetSelectedBranch
        //for displaying branch
        emit selectedBranch(selBranch);
    }
    catch(QString str)
    {
        QMessageBox::warning(NULL, tr("Warning"), str,QMessageBox::Ok,QMessageBox::NoButton);
        return;
    }
}

/**
  特技取得ボタン
  */
void MemeWindow::on_GetTokugiButton_clicked()
{
    try
    {
        if(getSelectedCategory()->getMeme())
        {
            emit selectedMemeTokugi(getTokugi(ui->MemeTableWidget, _memeTokugiTableWidget, _memeList));
        }
        else if(getSelectedCategory()->getBranch())
        {
            emit selectedBranchTokugi(getTokugi(ui->BranchTableWidget, _branchTokugiTableWidget, _branchList));
        }
        else
        {
            throw tr("データがなにかおかしい");
        }
        return;
    }
    catch(QString str)
    {
        QMessageBox::warning(this, tr("Warning"), str, QMessageBox::Ok, QMessageBox::NoButton);
    }
}

void MemeWindow::on_tokugiTableWidget_clicked(QModelIndex index)
{
    _memeTokugiTableWidget->resizeColumnsToContents();
    _branchTokugiTableWidget->resizeColumnsToContents();
}
