#ifndef MEMEWINDOW_H
#define MEMEWINDOW_H
#include <QTableWidgetItem>
#include <QTableWidget>
#include "categorywindow.h"

namespace Ui {
    class MemeWindow;
}

class MemeWindow : public CategoryWindow
{
    Q_OBJECT

public:
    explicit MemeWindow(CategoryWindow *parent = 0);
    virtual ~MemeWindow();

    virtual bool addMeme(Data*);
    virtual bool setTableResize();

protected:
    void changeEvent(QEvent *e);
    void resizeEvent(QResizeEvent *);

private:
    Ui::MemeWindow *ui;
    QList<Data*> _memeList;
    QTableWidget *_memeTokugiTableWidget;
    QList<Data*> _branchList;
    QTableWidget *_branchTokugiTableWidget;

private slots:
    void on_tokugiTableWidget_clicked(QModelIndex index);
    void on_GetTokugiButton_clicked();
    void on_GetMemeButton_clicked();
    void on_GetBranchButton_clicked();
    void on_MemeTableWidget_clicked(QModelIndex index);
    void on_BranchTableWidget_clicked(QModelIndex index);

signals:
    //to MainWindow
    void selectedMeme(Data *meme);
    void selectedBranch(Data *branch);
    void selectedMemeTokugi(Data *tokugi);
    void selectedBranchTokugi(Data *tokugi);
};
#endif // MEMEWINDOW_H
