#include "possibletokugiform.h"
#include "ui_possibletokugiform.h"
#include <QMessageBox>
#include <QDebug>

PossibleTokugiForm::PossibleTokugiForm(QWidget *parent) :
        QWidget(parent),
        ui(new Ui::PossibleTokugiForm),
        _tokugiList(),
        _OwnGenreal(NULL)
{
    ui->setupUi(this);
    setTableResize();
}

PossibleTokugiForm::~PossibleTokugiForm()
{
    delete ui;
}

bool PossibleTokugiForm::setTableResize()
{
    ui->TokugiTableWidget->horizontalHeader()->setResizeMode(QHeaderView::ResizeToContents);
    return true;
}

/**
  特技追加
  */
bool PossibleTokugiForm::addTokugi(Data *data)
{
    try
    {
        int baseColumn = -1;
        for(int k=0;k<ui->TokugiTableWidget->columnCount();k++)
        {
            if( ui->TokugiTableWidget->horizontalHeaderItem(k)->text().contains(QObject::tr("所属")) )
            {
                baseColumn = k;
                break;
            }
        }
        if(baseColumn==-1)
        {
            throw QObject::tr("所属列が見つかりません");
        }

        for(int i=0;data->GetChild(i)!=NULL;++i)
        {
            Data* tokugi = data->GetChild(i);
            if(tokugi->GetTokugi() == NULL)
            {
                continue;
            }

            if(ui->TokugiTableWidget->itemAt(0, 0) == NULL)
            {
                ui->TokugiTableWidget->setRowCount(1);
            }
            else
            {
                ui->TokugiTableWidget->setRowCount(ui->TokugiTableWidget->rowCount()+1);
            }
            _tokugiList.append(tokugi);

            int row = ui->TokugiTableWidget->rowCount() -1;
            ui->TokugiTableWidget->setItem(row, baseColumn, new QTableWidgetItem( tokugi->GetParent()->GetName(), 0) );

            QVector<QString> tokugiProperty = tokugi->GetProperty();
            //ここの順番を柔軟にしたい
            for(int j=0;j<tokugiProperty.size();j++)
            {
                ui->TokugiTableWidget->setItem(row, j+1, new QTableWidgetItem( tokugiProperty.value(j), 0 ));
            }
        }
        ui->TokugiTableWidget->resizeColumnsToContents();

        return true;
    }
    catch(QString str)
    {
        QMessageBox::warning(ui->TokugiTableWidget, QObject::tr("Warning"), str, QMessageBox::Ok, QMessageBox::NoButton);
        return false;
    }
}

bool PossibleTokugiForm::setGeneral(Data *general)
{
    _OwnGenreal = general;
    return true;
}

Data* PossibleTokugiForm::getTokugi(int num)
{
    return _tokugiList.value(num);
}

/*
 slots
 */

/**
  */
void PossibleTokugiForm::getRemovedCategory(Data *parent)
{
    for(int i=0;i<_tokugiList.size();)
    {
        Data *tokugi = _tokugiList.at(i);
        if(tokugi->GetParent() == parent)
        {
            _tokugiList.removeAt(i);
            ui->TokugiTableWidget->removeRow(i);
        }
        else
        {
            ++i;
        }
    }
}

/**
  コロナ特技取得
  */
void PossibleTokugiForm::GetSelectedCorona(Data *corona)
{
    addTokugi(corona);
}

/**
  ミーム特技取得
  */
void PossibleTokugiForm::GetSelectedMeme(Data *meme)
{
    addTokugi(meme);
}

/**
  ブランチ特技取得
  */
void PossibleTokugiForm::GetSelectedBranch(Data *branch)
{
    addTokugi(branch);
}


void PossibleTokugiForm::on_TokugiButton_clicked()
{
    emit selectedTokugi(_tokugiList.value(ui->TokugiTableWidget->currentRow()));
}

void PossibleTokugiForm::resizeEvent(QResizeEvent *)
{
    ui->TokugiTableWidget->resizeColumnsToContents();
}

void PossibleTokugiForm::on_TokugiTableWidget_cellClicked(int row, int column)
{
    ui->TokugiTableWidget->resizeColumnToContents(column);
}
