#ifndef POSSIBLETOKUGIFORM_H
#define POSSIBLETOKUGIFORM_H

#include <QList>
#include <QWidget>
#include "data.h"
#include "corona.h"
#include "meme.h"
#include "branch.h"
#include "tokugi.h"

namespace Ui {
    class PossibleTokugiForm;
}

class PossibleTokugiForm : public QWidget
{
    Q_OBJECT

public:
    explicit PossibleTokugiForm(QWidget *parent = 0);
    ~PossibleTokugiForm();

    virtual bool setTableResize();
    virtual bool addTokugi(Data *parent);
    virtual bool setGeneral(Data *general);
    virtual Data* getTokugi(int num);

private:
    Ui::PossibleTokugiForm *ui;
    QList<Data*> _tokugiList;
    Data* _OwnGenreal;

signals:
    void selectedTokugi(Data *tokugi);

public slots:
    void GetSelectedCorona(Data* corona);
    void GetSelectedMeme(Data* meme);
    void GetSelectedBranch(Data* branch);
    void getRemovedCategory(Data* category);

private slots:
    void on_TokugiTableWidget_cellClicked(int row, int column);
    void resizeEvent(QResizeEvent *);
    void on_TokugiButton_clicked();
};

#endif // POSSIBLETOKUGIFORM_H
